﻿using System.Collections.Generic;
using System.IO;
using System.Linq;

namespace UMK
{
    class RejestrZdarzeń
    {
        private const string ścieżkaPliku = "rejestrZdarzeń.txt";

        private bool natychmiastZapisujDoPliku;
        private List<string> zdarzenia = null;

        public RejestrZdarzeń(bool natychmiastZapisujDoPliku = true)
        {
            this.natychmiastZapisujDoPliku = natychmiastZapisujDoPliku;
            if (File.Exists(ścieżkaPliku))
                zdarzenia = File.ReadAllLines(ścieżkaPliku).ToList();
            else
                zdarzenia = new List<string>();
        }

        public void Zapisz()
        {
            File.WriteAllLines(ścieżkaPliku, zdarzenia.ToArray());
        }

        public void DodajZdarzenie(string zdarzenie)
        {
            zdarzenia.Add(zdarzenie);
            if (natychmiastZapisujDoPliku) Zapisz();
        }
    }
}
