﻿using Java.IO;
using Java.Lang;
using System;
using System.Runtime.CompilerServices;

namespace StanUrzadzenia
{
    //zob. https://forums.xamarin.com/discussion/18775/retrieve-device-memory-os-versions-drive-space-system-uid-folders-context
    public static class LinuxHelper
    {
        [MethodImpl(MethodImplOptions.Synchronized)]
        public static int ReadRAMTotalSizeKB()
        {
            try
            {
                RandomAccessFile reader = new RandomAccessFile("/proc/meminfo", "r"); //klasa Java
                string s = reader.ReadLine();
                reader.Close();
                string _sr = "memtotal:";
                s = s.ToLower();
                s = s.Remove(s.LastIndexOf(_sr), _sr.Length);
                s = s.Remove(s.LastIndexOf("kb"));
                s = s.Trim();
                int m = int.Parse(s);
                return m;
            }
            catch (IOException exc)
            {
                exc.PrintStackTrace();
                return -1;
            }
        }

        //http://stackoverflow.com/questions/3118234/how-to-get-memory-usage-and-cpu-usage-in-android
        public static float ReadCPUUsage()
        {
            try
            {
                RandomAccessFile reader = new RandomAccessFile("/proc/stat", "r");
                string load = reader.ReadLine();

                string[] toks = load.Split(' ');

                long idle1 = long.Parse(toks[5]);
                long cpu1 = long.Parse(toks[2]) + long.Parse(toks[3]) + long.Parse(toks[4])
                      + long.Parse(toks[6]) + long.Parse(toks[7]) + long.Parse(toks[8]);

                try
                {
                    Java.Lang.Thread.Sleep(360);
                }
                catch //(Java.Lang.Exception e) 
                { }

                reader.Seek(0);
                load = reader.ReadLine();
                reader.Close();

                toks = load.Split(' ');

                long idle2 = long.Parse(toks[5]);
                long cpu2 = long.Parse(toks[2]) + long.Parse(toks[3]) + long.Parse(toks[4])
                    + long.Parse(toks[6]) + long.Parse(toks[7]) + long.Parse(toks[8]);

                return (float)(cpu2 - cpu1) / ((cpu2 + idle2) - (cpu1 + idle1));

            }
            catch (IOException exc)
            {
                exc.PrintStackTrace();
            }

            return 0;
        }

        //http://www.roman10.net/how-to-get-cpu-information-on-android/
        public static string ReadCPUInfo()
        {
            StringBuffer sb = new StringBuffer();
            //sb.append("abi: ").append(Build.CPU_ABI).append("\n");
            if (new File("/proc/cpuinfo").Exists())
            {
                try
                {
                    BufferedReader br = new BufferedReader(new FileReader(new File("/proc/cpuinfo")));
                    string line;
                    while ((line = br.ReadLine()) != null)
                    {
                        sb.Append(line + "\n");
                    }
                    if (br != null)
                    {
                        br.Close();
                    }
                }
                catch (IOException exc)
                {
                    exc.PrintStackTrace();
                }
            }
            return sb.ToString();
        }
    }
}