﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Views;

namespace Pierscien
{
    [Activity(Label = "Pierscien", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private void pokażToast(string tekst)
        {
            RunOnUiThread(() => { Toast.MakeText(ApplicationContext, tekst, ToastLength.Short).Show(); });
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            Java.Lang.Thread t = new Java.Lang.Thread(
                () =>
                {
                    try
                    {
                        Java.Lang.Thread.Sleep(5000);
                        //Toast.MakeText(this, "Inicjacja zakończona", ToastLength.Short).Show();
                        pokażToast("Inicjacja zakończona");
                    }
                    catch (Java.Lang.InterruptedException exc)
                    {
                        pokażToast("Działanie wątku przerwane: " + exc.Message);
                    }
                    finally
                    {
                        RunOnUiThread(
                            () =>
                            {
                                View panel = FindViewById(Resource.Id.druzynaPierscienia);
                                panel.Visibility = ViewStates.Gone;
                                Toast.MakeText(ApplicationContext, "Panel został ukryty", ToastLength.Short).Show();
                            });
                    }
                });
            t.Start();
        }
    }
}

