﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Content;

namespace Uslugi
{
    [Activity(Label = "Uslugi", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private Button button1, button2;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            button1 = this.FindViewById<Button>(Resource.Id.button1);
            button2 = this.FindViewById<Button>(Resource.Id.button2);

            button1.Click +=
                (object sender, System.EventArgs e) =>
                {
                    if (!Usluga.CzyUtworzona)
                    {
                        Toast.MakeText(ApplicationContext, "Uruchamiam usługę", ToastLength.Short).Show();
                        this.StartService(new Intent(this, typeof(Usluga)));
                    } else Toast.MakeText(ApplicationContext, "Usługa już jest uruchomiona", ToastLength.Short).Show();
                };
            button2.Click +=
                (object sender, System.EventArgs e) =>
                {
                    Toast.MakeText(ApplicationContext, "Zatrzymuję usługę", ToastLength.Short).Show();
                    this.StopService(new Intent(this, typeof(Usluga)));
                };
        }

    }
}

