﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using System.Globalization;
using System.IO;
using Org.XmlPull.V1;
using Android.Util;

namespace BazaDanychSQLite
{
    public static class PlikXml
    {
        public static void ZapiszOsobyDoPlikuXml(Activity activity, Osoba[] osoby, string nazwaPlikuXml, IFormatProvider formatProvider = null)
        {
            if (formatProvider == null) formatProvider = CultureInfo.InvariantCulture;

            Stream fos = activity.OpenFileOutput(nazwaPlikuXml, FileCreationMode.Private);

            IXmlSerializer xml = Xml.NewSerializer();
            xml.SetOutput(fos, "UTF-8");
            xml.StartDocument("UTF-8", Java.Lang.Boolean.True);
            xml.SetFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);

            string ns = null;
            xml.StartTag(ns, "Osoby");
            xml.Attribute(ns, "length", osoby.Length.ToString(formatProvider));

            foreach (Osoba osoba in osoby)
            {
                xml.StartTag(ns, "Osoba");
                xml.Attribute(ns, "ID", osoba.Id.ToString(formatProvider));

                xml.StartTag(ns, "Imię");
                xml.Text(osoba.Imię);
                xml.EndTag(ns, "Imię");

                xml.StartTag(ns, "Nazwisko");
                xml.Text(osoba.Nazwisko);
                xml.EndTag(ns, "Nazwisko");

                xml.StartTag(ns, "Wiek");
                xml.Text(osoba.Wiek.ToString(formatProvider));
                xml.EndTag(ns, "Wiek");

                xml.StartTag(ns, "NumerTelefonu");
                xml.Text(osoba.NumerTelefonu.ToString(formatProvider));
                xml.EndTag(ns, "NumerTelefonu");

                xml.EndTag(ns, "Osoba");
            }

            xml.EndTag(ns, "Osoby");
            xml.EndDocument();
            xml.Flush();
            fos.Close();
        }
    }
}