﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;
using Android.Graphics;

namespace Grafika2D
{
    public class Grafika2DView : View
    {
        private Paint paint;
        int szerokość, wysokość;

        public Grafika2DView(Context context, IAttributeSet attrs) :
            base(context, attrs)
        {
            paint = new Paint(PaintFlags.AntiAlias);
            paint.SetStyle(Paint.Style.FillAndStroke);
            paint.StrokeWidth = 10;

            szerokość = this.Width;
            wysokość = this.Height;
            Log.Debug("View.ctor", "szer: " + szerokość.ToString());
            Log.Debug("View.ctor", "wys: " + wysokość.ToString());

            SetBackgroundColor(Color.Cyan);
        }

        protected override void OnSizeChanged(int w, int h, int oldw, int oldh)
        {
            base.OnSizeChanged(w, h, oldw, oldh);

            szerokość = this.Width;
            wysokość = this.Height;
            Log.Debug("View.OnSizeChanged", "szer: " + szerokość.ToString());
            Log.Debug("View.OnSizeChanged", "wys: " + wysokość.ToString());

            prost1 = new Rect(0, wysokość / 2, szerokość, wysokość);
            prost2 = new Rect(szerokość / 10, wysokość / 3, 5 * szerokość / 10, 2 * wysokość / 3);
            prost3 = new Rect(7 * szerokość / 40, 9 * wysokość / 20, 5 * szerokość / 20, 2 * wysokość / 3);
        }

        private Rect prost1, prost2, prost3;
        private Rect[] prostOkna;

        public override void Draw(Canvas canvas)
        {
            base.Draw(canvas);

            paint.Color = Color.Yellow;

            int x0 = 4 * szerokość / 5;
            int y0 = wysokość / 4;
            int r1 = wysokość / 10;            
            canvas.DrawCircle(x0, y0, r1, paint);

            int ilePromieni = 8;
            int r2 = 2 * r1;
            double wsp = 2 * Math.PI / ilePromieni;
            for(int i = 0; i < ilePromieni; ++i)
            {
                canvas.DrawLine(x0, y0, x0 + r2 * (float)Math.Cos(wsp * i), y0 + r2 * (float)Math.Sin(wsp * i), paint);
            }

            paint.Color = Color.Lime;
            canvas.DrawRect(prost1, paint);

            paint.Color = Color.White;
            canvas.DrawRect(prost2, paint);

            paint.Color = Color.Brown;
            canvas.DrawRect(prost3, paint);
        }
    }
}