﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;
using Android.Graphics;

namespace Grafika2D
{
    public class Grafika2DView : View
    {
        private Paint paint;
        int szerokość, wysokość;
        DateTime startTime = DateTime.Now;

        public Grafika2DView(Context context, IAttributeSet attrs) :
            base(context, attrs)
        {
            paint = new Paint(PaintFlags.AntiAlias);
            paint.SetStyle(Paint.Style.FillAndStroke);
            paint.StrokeWidth = 10;

            szerokość = this.Width;
            wysokość = this.Height;
            Log.Debug("View.ctor", "szer: " + szerokość.ToString());
            Log.Debug("View.ctor", "wys: " + wysokość.ToString());

            SetBackgroundColor(Color.Cyan);
        }

        protected override void OnSizeChanged(int w, int h, int oldw, int oldh)
        {
            base.OnSizeChanged(w, h, oldw, oldh);

            szerokość = this.Width;
            wysokość = this.Height;
            Log.Debug("View.OnSizeChanged", "szer: " + szerokość.ToString());
            Log.Debug("View.OnSizeChanged", "wys: " + wysokość.ToString());

            prost1 = new Rect(0, wysokość / 2, szerokość, wysokość);
            prost2 = new Rect(szerokość / 10, wysokość / 3, 5 * szerokość / 10, 2 * wysokość / 3);
            prost3 = new Rect(7 * szerokość / 40, 9 * wysokość / 20, 5 * szerokość / 20, 2 * wysokość / 3);

            ścieżka = new Path();
            ścieżka.SetFillType(Path.FillType.EvenOdd);
            ścieżka.MoveTo(szerokość / 10, wysokość / 3);
            ścieżka.LineTo(2 * szerokość / 10, wysokość / 6);
            ścieżka.LineTo(4 * szerokość / 10, wysokość / 6);
            ścieżka.LineTo(5 * szerokość / 10, wysokość / 3);
            ścieżka.LineTo(szerokość / 10, wysokość / 3);
            ścieżka.Close();

            rysunek = BitmapFactory.DecodeResource(Resources, Resource.Drawable.Rysunek);
            if (rysunek == null) Log.Error("View.OnSizeChanged", "Obraz nie został poprawnie wczytany");
        }

        private Rect prost1, prost2, prost3;
        private Rect[] prostOkna; //W DOMU!!!
        private Path ścieżka;
        private Bitmap rysunek;

        public override void Draw(Canvas canvas)
        {
            base.Draw(canvas);

            //słońce
            paint.Color = Color.Yellow;
            int x0 = 4 * szerokość / 5;
            int y0 = wysokość / 4;
            int r1 = wysokość / 10;            
            canvas.DrawCircle(x0, y0, r1, paint);

            int ilePromieni = 8;
            int r2 = 2 * r1;
            double wsp = 2 * Math.PI / ilePromieni;
            for(int i = 0; i < ilePromieni; ++i)
            {
                canvas.DrawLine(x0, y0, x0 + r2 * (float)Math.Cos(wsp * i), y0 + r2 * (float)Math.Sin(wsp * i), paint);
            }

            //trawa
            paint.Color = Color.Lime;
            canvas.DrawRect(prost1, paint);

            //ściany
            paint.Color = Color.White;
            canvas.DrawRect(prost2, paint);

            //drzwi
            paint.Color = Color.Brown;
            canvas.DrawRect(prost3, paint);

            //dach
            paint.Color = Color.Red;
            canvas.DrawPath(ścieżka, paint);

            //rysunek            
            double seconds = (DateTime.Now - startTime).TotalSeconds;
            int x1 = szerokość / 2 + (int)(300 * Math.Sin(seconds / 1.0));
            int y1 = 4 * wysokość / 10;
            float wsp1 = (float)rysunek.Height / rysunek.Width;
            int dx = szerokość / 10;
            int dy = (int)(dx * wsp1);            
            canvas.DrawBitmap(rysunek, null, new Rect(x1, y1, x1 + dx, y1 + dy), paint);

            Invalidate();
        }
    }
}