﻿using Android.App;
using Android.Widget;
using Android.OS;
using System.Collections.Generic;

namespace Kontakty
{
    using Models;

    [Activity(Label = "Kontakty", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private TextView nagłówek;
        private ListView listView;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            nagłówek = FindViewById<TextView>(Resource.Id.nagłówek);
            listView = FindViewById<ListView>(Resource.Id.listView);

            try
            {
                Kontakt kontakt1 = new Kontakt("Jacek Matulewski", "123456789", null, "jacek@fizyka.umk.pl", null, null);
                KontaktHelper.DodajNowyKontakt(this.ContentResolver, kontakt1);
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext, "Nie udało się dodać kontaktu: " + exc.Message, ToastLength.Long).Show();
            }

            showContacts();
        }

        private void showContacts()
        {
            List<string> listaKontaktów = KontaktHelper.ListaNazwWszystkichKontaktów(this.ContentResolver);
            if (listaKontaktów == null)
            {
                nagłówek.Text = "Brak kontaktów";
            }
            else
            {
                ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, listaKontaktów);
                listView.Adapter = adapter;
            }
        }
    }
}

