﻿using Android.Content;
using Android.Database;
using Android.Net;
using Android.Provider;
using System.Collections.Generic;

namespace Kontakty.Models
{
    public static class KontaktHelper
    {
        public static List<string> ListaNazwWszystkichKontaktów(ContentResolver contentResolver)
        {
            List<string> lista = null;
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                lista = new List<string>();
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            else
            {
                lista = null;
            }
            cursor.Close();
            return lista;
        }

        public static void UsuńWszystkieKontakty(ContentResolver contentResolver)
        {
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);

            while(cursor.MoveToNext())
            {
                string klucz = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.LookupKey));
                Uri uri = Uri.WithAppendedPath(ContactsContract.Contacts.ContentLookupUri, klucz);
                contentResolver.Delete(uri, null, null);
            }
        }

        public static void DodajNowyKontakt(ContentResolver contentResolver, Kontakt kontakt)
        {
            List<ContentProviderOperation> dodawanyKontakt = new List<ContentProviderOperation>();
            dodawanyKontakt.Add(
                ContentProviderOperation.NewInsert(
                    ContactsContract.RawContacts.ContentUri)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountType, null)
                    .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountName, null).Build());

            if(kontakt.NazwaWyświetlana != null)
            {
                dodawanyKontakt.Add(
                ContentProviderOperation.NewInsert(
                    ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.StructuredName.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.StructuredName.DisplayName, kontakt.NazwaWyświetlana).Build());
            }

            if (kontakt.TelefonKomórkowy != null)
            {
                dodawanyKontakt.Add(
                ContentProviderOperation.NewInsert(
                    ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.Number, kontakt.TelefonKomórkowy)
                    .WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Type,
                    ContactsContract.CommonDataKinds.Phone.InterfaceConsts.TypeCustom).
                    WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Mobile")
                    .Build());
            }

            if (kontakt.EmailPraca != null)
            {
                dodawanyKontakt.Add(
                ContentProviderOperation.NewInsert(
                    ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Phone.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data, kontakt.EmailPraca)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type,
                    ContactsContract.CommonDataKinds.Email.InterfaceConsts.TypeCustom).
                    WithValue(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label, "Work")
                    .Build());
            }

            contentResolver.ApplyBatch(ContactsContract.Authority, dodawanyKontakt);
        }

        private static Kontakt odczytajKontakt(ContentResolver contentResolver, ICursor cursor)
        {
            string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
            string nazwaWyświetlana = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
            
            string telefonKomórkowy = "";

            string sLiczbaTelefonów = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.HasPhoneNumber));
            int liczbaTelefonów = int.Parse(sLiczbaTelefonów);
            if(liczbaTelefonów > 0)
            {
                ICursor numeryTelefonów = contentResolver.Query(ContactsContract.CommonDataKinds.Phone.ContentUri, null, ContactsContract.CommonDataKinds.Phone.InterfaceConsts.ContactId + "=" + id, null, null);
                while(numeryTelefonów.MoveToNext())
                {
                    string numer = numeryTelefonów.GetString(numeryTelefonów.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.Number));
                    string typNumeru = numeryTelefonów.GetString(numeryTelefonów.GetColumnIndex(ContactsContract.CommonDataKinds.Phone.InterfaceConsts.Label));
                    if (typNumeru == "Mobile") telefonKomórkowy = numer;
                }
                numeryTelefonów.Close();
            }

            cursor.Close();

            return new Kontakt(nazwaWyświetlana, telefonKomórkowy, null, null, null, null);
        }
    }
}