package pl.umk.fizyka.kolory;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
{
    private TextView panel;
    private SeekBar seekBarR, seekBarG, seekBarB;
    private Spinner spinner;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        panel = (TextView) findViewById(R.id.panel);
        seekBarR = (SeekBar) findViewById(R.id.seekBarR);
        seekBarG = (SeekBar) findViewById(R.id.seekBarG);
        seekBarB = (SeekBar) findViewById(R.id.seekBarB);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        seekBarR.setProgress(0);
        seekBarG.setProgress(0);
        seekBarB.setProgress(0);

        float promień = 8;
        float[] zewnętrznePromienie = new float[] { promień, promień, promień, promień, promień, promień, promień, promień };
        RoundRectShape rrs = new RoundRectShape(zewnętrznePromienie, null, null);
        ShapeDrawable sdR = new ShapeDrawable(rrs);
        sdR.getPaint().setShader(new LinearGradient(0, 0, 200, 0, Color.BLACK, Color.RED, Shader.TileMode.CLAMP));
        seekBarR.setProgressDrawable(sdR);
        ShapeDrawable sdG = new ShapeDrawable(rrs);
        sdG.getPaint().setShader(new LinearGradient(0, 0, 200, 0, Color.BLACK, Color.GREEN, Shader.TileMode.CLAMP));
        seekBarG.setProgressDrawable(sdG);
        ShapeDrawable sdB = new ShapeDrawable(rrs);
        sdB.getPaint().setShader(new LinearGradient(0, 0, 200, 0, Color.BLACK, Color.BLUE, Shader.TileMode.CLAMP));
        seekBarB.setProgressDrawable(sdB);

        spinner = findViewById(R.id.spinner);
        ArrayAdapter<?> adapter = ArrayAdapter.createFromResource(
                this,
                R.array.kolory,
                android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);

        spinner.setOnItemSelectedListener(spinnerItemSelectedListener);
        spinner.setSelection(1);
    }

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener =
            new SeekBar.OnSeekBarChangeListener() {
                @Override
                public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                    int _r = seekBarR.getProgress();
                    int _g = seekBarG.getProgress();
                    int _b = seekBarB.getProgress();

                    panel.setBackgroundColor(Color.argb(255, _r, _g, _b));
                    panel.setText("Składowe koloru: #" +
                            Integer.toHexString(_r).toUpperCase() +
                            Integer.toHexString(_g).toUpperCase() +
                            Integer.toHexString(_b).toUpperCase());

                    //int jasność = (_r + _g + _b) / 3;
                    int jasność = (int)(0.2989*_r + 0.5870*_g + 0.1140*_b);
                    if (jasność > 127) panel.setTextColor(Color.BLACK);
                    else panel.setTextColor(Color.WHITE);

                    //spinner.setSelection(0); //ta instrukcja powoduje błąd
                }

                @Override
                public void onStartTrackingTouch(SeekBar seekBar) {
                    //nie używane
                }

                @Override
                public void onStopTrackingTouch(SeekBar seekBar) {
                    //nie używane
                }
            };

    private Spinner.OnItemSelectedListener spinnerItemSelectedListener =
            new Spinner.OnItemSelectedListener()
            {
                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int selection, long id)
                {
                    switch(selection)
                    {
                        case 0:
                            //
                            break;
                        case 1: //czarny
                            seekBarR.setProgress(0);
                            seekBarG.setProgress(0);
                            seekBarB.setProgress(0);
                            break;
                        case 2: //biały
                            seekBarR.setProgress(255);
                            seekBarG.setProgress(255);
                            seekBarB.setProgress(255);
                            break;
                        case 3: //czerwony
                            seekBarR.setProgress(255);
                            seekBarG.setProgress(0);
                            seekBarB.setProgress(0);
                            break;
                        case 4: //zielony
                            seekBarR.setProgress(0);
                            seekBarG.setProgress(255);
                            seekBarB.setProgress(0);
                            break;
                        case 5: //czerwony
                            seekBarR.setProgress(0);
                            seekBarG.setProgress(0);
                            seekBarB.setProgress(255);
                            break;
                    }
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView)
                {

                }
            };
}
