package pl.umk.fizyka.intencje;

import android.Manifest;
import android.app.Activity;
import android.app.SearchManager;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import java.security.Permission;

public class MainActivity extends AppCompatActivity {

    private Button button;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);



        button = findViewById(R.id.button);
        button.setOnClickListener(new View.OnClickListener()
        {
            @Override
            public void onClick(View view) {
                //Intent i = new Intent(MainActivity.this, InnaAktywnosc.class);
                //finish();
                //startActivity(i);

                //Intent i = new Intent(Intent.ACTION_VIEW);
                //i.setData(Uri.parse("http://www.fizyka.umk.pl/~jacek"));
                //startActivity(i);

                //Intent i = new Intent(Intent.ACTION_WEB_SEARCH);
                //i.putExtra(SearchManager.QUERY, "umk");
                //startActivity(i);

                //String uri = "geo:53.012749,18.61278?q=Grudziadzka 5";
                //Intent i = new Intent(Intent.ACTION_VIEW);
                //i.setData(Uri.parse(uri));
                //startActivity(i);

                //wymaga wywołania checkPermission
                try {
                    if (zdobądźUprawnienia(MainActivity.this)) {
                        Intent i = new Intent(Intent.ACTION_CALL);
                        //Intent i = new Intent(Intent.ACTION_DIAL);
                        i.setData(Uri.parse("tel:12345778"));
                        startActivity(i);
                        Toast.makeText(getApplicationContext(), "Dzwonienie rozpoczęte", Toast.LENGTH_SHORT).show();
                    }
                }
                catch (SecurityException exc)
                {
                    Toast.makeText(getApplicationContext(), "Błąd: " + exc.getMessage(), Toast.LENGTH_SHORT).show();
                }
            }
        });
    }

    public static final int idProsbyOUprawnienieDoDzwonienia = 0;

    private static boolean zdobądźUprawnienia(Activity activity)
    {
        int permissionCheck = ContextCompat.checkSelfPermission(activity, Manifest.permission.CALL_PHONE);
        if(permissionCheck != PackageManager.PERMISSION_GRANTED)
        {
            ActivityCompat.requestPermissions(activity, new String[]{ Manifest.permission.CALL_PHONE }, idProsbyOUprawnienieDoDzwonienia);
            Toast.makeText(activity.getApplicationContext(), "Wysłano prośbę o uprawnienie", Toast.LENGTH_SHORT).show();
            return false;
        }
        else
        {
            Toast.makeText(activity.getApplicationContext(), "Uprawnienie było przyznane", Toast.LENGTH_SHORT).show();
            return true;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults)
    {
        //super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode)
        {
            case idProsbyOUprawnienieDoDzwonienia:
                Toast.makeText(getApplicationContext(), "Uprawnienie zostało właśnie przyznane", Toast.LENGTH_SHORT).show();
                break;
        }
    }
}
