package pl.umk.fizyka.powiadomienia;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;

public class MainActivity extends AppCompatActivity {

    EditText tytul, tresc;
    Button pokaz, ukryj;
    int idPowiadomienia = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        tytul = (EditText)findViewById(R.id.tytul);
        tresc = (EditText)findViewById(R.id.tresc);
        pokaz = (Button)findViewById(R.id.pokaz);
        ukryj = (Button)findViewById(R.id.ukryj);

        pokaz.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        Intent i = new Intent(getApplicationContext(), MainActivity.class);
                        PendingIntent pi = PendingIntent.getActivity(getApplicationContext(), 0, i, 0);

                        NotificationCompat.Builder nb = new NotificationCompat.Builder(getApplicationContext());
                        nb.setSmallIcon(R.mipmap.ic_launcher);
                        nb.setContentTitle(tytul.getText());
                        nb.setContentText(tresc.getText());
                        nb.addAction(R.mipmap.ic_launcher, "Uruchom", pi);
                        nb.addAction(R.mipmap.ic_launcher, "Uruchom 2", pi);
                        nb.addAction(R.mipmap.ic_launcher, "Uruchom 3", pi);

                        Notification n = nb.build();
                        n.flags |= Notification.FLAG_AUTO_CANCEL;

                        NotificationManager nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
                        nm.notify(idPowiadomienia, n);
                    }
                }
        );

        ukryj.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        NotificationManager nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
                        nm.cancel(idPowiadomienia);
                    }
                }
        );
    }
}
