package pl.umk.fizyka.pierscien;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        Thread t = new Thread() {
            public void pokazToast(final String komunikat)
            {
                runOnUiThread(
                        new Runnable() {
                            @Override
                            public void run()
                            {
                                Toast.makeText(MainActivity.this, komunikat, Toast.LENGTH_SHORT).show();
                            }
                        }
                );
            }

            public void run()
            {
                try
                {
                    Thread.sleep(5000);
                    pokazToast("Inicjacja zakończona");
                }
                catch(InterruptedException exc)
                {
                    pokazToast("Błąd podczas inicjacji: " + exc.getMessage());
                }
                finally
                {
                    runOnUiThread(
                            new Runnable()
                            {
                                @Override
                                public void run()
                                {
                                    View panelPierscienia = findViewById(R.id.panelPierscienia);
                                    panelPierscienia.setVisibility(View.GONE);
                                    Toast.makeText(
                                            getApplicationContext(),
                                            "Panel pierścienia został ukryty",
                                            Toast.LENGTH_SHORT).show();
                                }
                            });
                }
            }
        };
        t.start();
    }
}
