﻿using Android.App;
using Android.Widget;
using Android.OS;

namespace App1
{
    [Activity(Label = "App1", MainLauncher = true)]
    public class MainActivity : Activity
    {
        private Button przycisk;
        private TextView etykieta;
        private ListView lista;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.Main);

            //przycisk = (Button)FindViewById(Resource.Id.button1);
            przycisk = FindViewById<Button>(Resource.Id.button1);
            
            /*
            przycisk.Click += 
                (object sender, System.EventArgs e) =>
                {
                    Toast.MakeText(this, "Hello World!", ToastLength.Long).Show();
                };
            */

            etykieta = FindViewById<TextView>(Resource.Id.textView1);
            lista = FindViewById<ListView>(Resource.Id.listView1);

            //etykieta.Text = "Uniwersytet Mikołaja Kopernika";

            string[] łańcuchy = new string[]
            {
                "tekst1", "tekst2", "tekst3", "tekst4"
            };
            ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, łańcuchy);
            lista.Adapter = adapter;
            lista.ItemClick += Lista_ItemClick;
        }

        private void Lista_ItemClick(object sender, AdapterView.ItemClickEventArgs e)
        {
            Toast.MakeText(this, "Kliknięta pozycja " + e.Position + " (" + (e.View as TextView).Text + ")", ToastLength.Short).Show();
        }

        [Java.Interop.Export("Przycisk_OnClick")]
        public void Przycisk_OnClick(Android.Views.View v)
        {
            Toast.MakeText(this, "Hello World!", ToastLength.Short).Show();
        }
    }
}

