﻿using System;

//using Android.App;
//using Android.Widget;

namespace App1
{
    //tablice, kolekcje, tworzenie własności, zdarzeń, klasy-struktury
    public class Klasa : IDisposable
    {
        private float pole = 2;

        private float kwadrat(float argument)
        {
            return argument * argument;
        }

        public float Własność
        {
            get
            {
                return pole;
            }
            set
            {
                float staraWartość = pole;
                pole = value;
                if (pole != staraWartość) onPoleZmienione(staraWartość, pole);
            }
        }

        public string Łańcuch
        {
            get
            {
                return pole.ToString();
            }
            set
            {
                //pole = float.Parse(value);

                float wartość;
                bool wynik = float.TryParse(value, out wartość);
                if (!wynik) throw new Exception("Łańcuch nie zawiera liczby typu float");
                else Własność = wartość;
            }
        }

        public class ZmianaEventArgs : EventArgs
        {
            public float StaraWartość;
            public float NowaWartość;
        }

        public event EventHandler<ZmianaEventArgs> PoleZmienione;

        protected void onPoleZmienione(float staraWartość, float nowaWartość)
        {
            //if (PoleZmienione != null) PoleZmienione(this, EventArgs.Empty);
            if (PoleZmienione != null)
                PoleZmienione(
                    this, 
                    new ZmianaEventArgs() { StaraWartość = staraWartość, NowaWartość = nowaWartość });
        }

        public void Dispose()
        {
            //
        }
    }

    public class InnaKlasa
    {
        private Klasa obiekt = null;
        //Klasa obiekt = new Klasa();

        public InnaKlasa(Klasa obiekt)
        {
            //obiekt = new Klasa();
            this.obiekt = obiekt;

            //obiekt.PoleZmienione = obiekt_PoleZmienione;
            obiekt.PoleZmienione += obiekt_PoleZmienione;
        }

        private void obiekt_PoleZmienione(object sender, Klasa.ZmianaEventArgs e)
        {
            //Toast.MakeText(Application.Context, "Pole zostało zmienione z " + e.StaraWartość + " na " + e.NowaWartość, ToastLength.Short).Show();
        }
    }

    public struct Struktura
    {
        private float pole;

        public float Własność
        {
            get
            {
                return pole;
            }
            set
            {
                pole = value;
            }
        }
    }
}