﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.Media;

namespace Uslugi
{
    [Service]
    class Usluga : Service
    {
        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        private Java.Util.Timer timer;
        private static Toast toastDlaTimera;

        class Zadanie : Java.Util.TimerTask
        {
            public override void Run()
            {
                ToneGenerator tg = new ToneGenerator(Stream.Alarm, 100);
                tg.StartTone(Tone.CdmaAlertCallGuard, 200);
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            toastDlaTimera = Toast.MakeText(ApplicationContext, "Za zdrowie timera", ToastLength.Short);

            timer = new Java.Util.Timer();
            timer.ScheduleAtFixedRate(new Zadanie(), 1000, 2000);

            CzyUtworzona = true;
            Toast.MakeText(ApplicationContext, "Usługa utworzona", ToastLength.Short).Show();
        }

        public override void OnDestroy()
        {
            timer.Cancel();
            CzyUtworzona = false;
            Toast.MakeText(ApplicationContext, "Usługa zatrzymana", ToastLength.Short).Show();

            base.OnDestroy();
        }

        [return: GeneratedEnum]
        public override StartCommandResult OnStartCommand(Intent intent, [GeneratedEnum] StartCommandFlags flags, int startId)
        {
            Toast.MakeText(ApplicationContext, "Usługa urychomiona", ToastLength.Short).Show();
            return base.OnStartCommand(intent, flags, startId);
        }

        //auto-implemented property
        public static bool CzyUtworzona { get; private set; } = false;

        /*
        private static bool _czyUtworzona = false;
        public static bool CzyUtworzona2
        {
            get
            {
                return _czyUtworzona;
            }
            set
            {
                _czyUtworzona = value;
            }
        }
        */
    }
}