﻿//using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Database;
using Android.Net;
using Android.OS;
using Android.Provider;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace JacekMatulewski.Android
{

    //klasa encji
    public class Kontakt
    {
        public string NazwaWyświetlana;
        public string TelefonKomórkowy;
        public string TelefonDomowy;
        public string TelefonWPracy;
        public string EmailWPracy;
        public string Firma;
        public string Tytuł;
        //można uzupełnić o zdjęcie

        public Kontakt(
            string nazwaWyświetlana,
            string telefonKomórkowy,
            string telefonDomowy,
            string telefonWPracy,
            string emailWPracy,
            string firma,
            string tytuł)
        {
            this.NazwaWyświetlana = nazwaWyświetlana;
            this.TelefonKomórkowy = telefonKomórkowy;
            this.TelefonDomowy = telefonDomowy;
            this.TelefonWPracy = telefonWPracy;
            this.EmailWPracy = emailWPracy;
            this.Firma = firma;
            this.Tytuł = tytuł;
        }

        public void Zapisz(ContentResolver contentResolver)
        {
            KontaktHelper.DodajKontakt(contentResolver, this);
        }
    }

    //pomocnik
    public static class KontaktHelper
    {
        public static List<string> ListaNazwWszystkichKontaktów(ContentResolver contentResolver)
        {
            List<string> lista = null;
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if(cursor.Count > 0)
            {
                lista = new List<string>();
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            cursor.Close();
            return lista;
        }

        public static void UsuńWszystkieKontakty(ContentResolver contentResolver)
        {
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count == 0) return;
            while(cursor.MoveToNext())
            {
                string klucz = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.LookupKey));
                Uri uri = Uri.WithAppendedPath(ContactsContract.Contacts.ContentLookupUri, klucz);
                contentResolver.Delete(uri, null, null);
            }
            cursor.Close();
        }

        public static void DodajKontakt(ContentResolver contentResolver, Kontakt kontakt)
        {
            List<ContentProviderOperation> dodawanyKontakt = new List<ContentProviderOperation>();

            dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.RawContacts.ContentUri)
                .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountType, null)
                .WithValue(ContactsContract.RawContacts.InterfaceConsts.AccountName, null)
                .Build());

            if(kontakt.NazwaWyświetlana != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.StructuredName.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.StructuredName.DisplayName, kontakt.NazwaWyświetlana)
                    .Build());
            }

            if(kontakt.EmailWPracy != null)
            {
                dodawanyKontakt.Add(ContentProviderOperation.NewInsert(ContactsContract.Data.ContentUri)
                    .WithValueBackReference(ContactsContract.Data.InterfaceConsts.RawContactId, 0)
                    .WithValue(ContactsContract.Data.InterfaceConsts.Mimetype, ContactsContract.CommonDataKinds.Email.ContentItemType)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Data, kontakt.EmailWPracy)
                    //.WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.GetTypeLabelResource(EmailDataKind.Work))
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Type, ContactsContract.CommonDataKinds.Email.InterfaceConsts.TypeCustom)
                    .WithValue(ContactsContract.CommonDataKinds.Email.InterfaceConsts.Label, "Work")
                    .Build());
            }

            contentResolver.ApplyBatch(ContactsContract.Authority, dodawanyKontakt);
        }
    }
}