﻿using System.Collections.Generic;

using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Content.PM;

using JacekMatulewski.Android;

namespace Kontakty
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private TextView naglowek;
        private ListView listaKontaktow;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            naglowek = FindViewById<TextView>(Resource.Id.naglowek);
            listaKontaktow = FindViewById<ListView>(Resource.Id.listaKontaktow);

            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                this.CheckSelfPermission(Android.Manifest.Permission.WriteContacts) != Android.Content.PM.Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.WriteContacts }, PERMISSION_REQUEST_WRITE_CONTACTS);
                Toast.MakeText(this, "Wysłana prośba o uprawnienia do zmiany kontaktów", ToastLength.Short).Show();
            }
            else
            {
                //TESTY - POCZĄTEK
                try
                {
                    KontaktHelper.UsuńWszystkieKontakty(this.ContentResolver);
                    Kontakt kontakt1 = new Kontakt("Jan Kowalski", "+48 123456789", "+48 (56) 11238489", "+48 (52) 23847897", "jacek@phys.uni.torun.pl", "UMK w Toruniu", "Dr");
                    Kontakt kontakt2 = new Kontakt("Drugi Kontakt", "+48 231423", "+48 (56) 32435", "+48 (52) 1234565", "drugi@phys.uni.torun.pl", null, null);
                    KontaktHelper.DodajKontakt(this.ContentResolver, kontakt1);
                    kontakt2.Zapisz(this.ContentResolver);
                }
                catch(Java.Lang.Exception exc)
                {
                    Toast.MakeText(this, exc.Message, ToastLength.Long).Show();
                }
                //TESTY - KONIEC1
            }
            
            if (Build.VERSION.SdkInt >= Android.OS.BuildVersionCodes.M &&
                this.CheckSelfPermission(Android.Manifest.Permission.ReadContacts) != Android.Content.PM.Permission.Granted)
            {
                this.RequestPermissions(new string[] { Android.Manifest.Permission.ReadContacts }, PERMISSION_REQUEST_READ_CONTACTS);
            }
            else showContacts();
        }

        private const int PERMISSION_REQUEST_READ_CONTACTS = 100;
        private const int PERMISSION_REQUEST_WRITE_CONTACTS = 101;

        private void showContacts()
        {
            List<string> lista = JacekMatulewski.Android.KontaktHelper.ListaNazwWszystkichKontaktów(this.ContentResolver);

            if(lista != null)
            {
                naglowek.Text = "Kontakty (" + lista.Count.ToString() + ")";
                ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, lista);
                listaKontaktow.Adapter = adapter;               
            }
            else
            {
                naglowek.Text = "Brak kontaktów";
            }
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Permission[] grantResults)
        {
            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            if(requestCode == PERMISSION_REQUEST_READ_CONTACTS)
            {
                if (grantResults[0] == Permission.Granted) showContacts();
                else Toast.MakeText(this, "Nie została udzielona zgoda na odczyt kontaktów", ToastLength.Long).Show();
            }
            if(requestCode == PERMISSION_REQUEST_WRITE_CONTACTS)
            {
                if(grantResults[0] == Permission.Granted) Toast.MakeText(this, "Udzielona została zgoda na odczyt kontaktów. Uruchom aplikację ponownie", ToastLength.Long).Show();
                else Toast.MakeText(this, "Nie została udzielona zgoda na zmianę kontaktów", ToastLength.Long).Show();
            }
        }
    }
}