﻿using System;
using System.IO;

using Android.App;
using Android.Content;
using Android.Util;
using Javax.Xml.Parsers;
using Org.W3c.Dom;
using Org.Xml.Sax;
using Org.XmlPull.V1;

namespace BazaDanych
{
    public static class PlikXml
    {
        public static void ZapiszDoPlikuXml(this Osoba[] osoby, Activity activity, string nazwaPlikuXml, IFormatProvider formatProvider = null)
        {
            if (formatProvider == null) formatProvider = System.Globalization.CultureInfo.InvariantCulture;
            Stream fos = activity.OpenFileOutput(nazwaPlikuXml, FileCreationMode.Private);

            IXmlSerializer xml = Xml.NewSerializer();
            xml.SetOutput(fos, "UTF-8");
            xml.StartDocument("UTF-8", Java.Lang.Boolean.True);
            xml.SetFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);

            string ns = null;
            xml.StartTag(ns, "Osoby");
            xml.Attribute(ns, "length", osoby.Length.ToString(formatProvider));

            foreach(Osoba osoba in osoby)
            {
                xml.StartTag(ns, "Osoba");
                xml.Attribute(ns, "ID", osoba.Id.ToString(formatProvider));

                xml.StartTag(ns, "Imie");
                xml.Text(osoba.Imię);
                xml.EndTag(ns, "Imie");

                xml.StartTag(ns, "Nazwisko");
                xml.Text(osoba.Nazwisko);
                xml.EndTag(ns, "Nazwisko");

                xml.StartTag(ns, "Wiek");
                xml.Text(osoba.Wiek.ToString(formatProvider));
                xml.EndTag(ns, "Wiek");

                xml.StartTag(ns, "NumerTelefonu");
                xml.Text(osoba.NumerTelefonu.ToString(formatProvider));
                xml.EndTag(ns, "NumerTelefonu");

                xml.EndTag(ns, "Osoba");
            }

            xml.EndTag(ns, "Osoby");

            xml.EndDocument();
            xml.Flush();

            fos.Close();
        }

        public static Osoba[] CzytajOsobyZPlikuXml(Activity activity, string nazwaPlikuXml)
        {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.NewInstance();
            DocumentBuilder db = dbf.NewDocumentBuilder();
            Stream fis = activity.OpenFileInput(nazwaPlikuXml);

            Java.IO.Reader r = new Java.IO.InputStreamReader(fis, "UTF-8");
            InputSource _is = new InputSource(r);
            _is.Encoding = "UTF-8";
            IDocument d = db.Parse(_is);

            INodeList węzły = d.GetElementsByTagName("Osoba");

            int n = węzły.Length;
            Osoba[] osoby = new Osoba[n];
            for(int i = 0; i < n; ++i)
            {
                INode węzeł = węzły.Item(i);
                string _id = węzeł.Attributes.GetNamedItem("ID").NodeValue;
                int id = int.Parse(_id);

                INodeList podwęzły = węzeł.ChildNodes;
                string imię = "", nazwisko = "";
                int wiek = -1, numerTelefonu = -1;
                
                for(int j = 0; j < podwęzły.Length; ++j)
                {
                    INode podwęzeł = podwęzły.Item(j);
                    string nazwaPodwęzła = podwęzeł.NodeName;
                    string wartość = "";
                    if (podwęzeł.HasChildNodes) wartość = podwęzeł.FirstChild.NodeValue;
                    switch(nazwaPodwęzła)
                    {
                        case "Imie": imię = wartość; break;
                        case "Nazwisko": nazwisko = wartość; break;
                        case "Wiek": wiek = int.Parse(wartość); break;
                        case "NumerTelefonu": numerTelefonu = int.Parse(wartość); break;
                    }
                }
                osoby[i] = new Osoba(id, imię, nazwisko, wiek, numerTelefonu);
            }
            return osoby;
        }


        //kopia metody ze zmianami
        public static Osoba[] CzytajOsobyZPlikuXml(Java.Net.URL url)
        {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.NewInstance();
            DocumentBuilder db = dbf.NewDocumentBuilder();
            Stream _is = url.OpenStream(); //<----------- tu zmiany
            IDocument d = db.Parse(_is);

            INodeList węzły = d.GetElementsByTagName("Osoba");

            int n = węzły.Length;
            Osoba[] osoby = new Osoba[n];
            for (int i = 0; i < n; ++i)
            {
                INode węzeł = węzły.Item(i);
                string _id = węzeł.Attributes.GetNamedItem("ID").NodeValue;
                int id = int.Parse(_id);

                INodeList podwęzły = węzeł.ChildNodes;
                string imię = "", nazwisko = "";
                int wiek = -1, numerTelefonu = -1;

                for (int j = 0; j < podwęzły.Length; ++j)
                {
                    INode podwęzeł = podwęzły.Item(j);
                    string nazwaPodwęzła = podwęzeł.NodeName;
                    string wartość = "";
                    if (podwęzeł.HasChildNodes) wartość = podwęzeł.FirstChild.NodeValue;
                    switch (nazwaPodwęzła)
                    {
                        case "Imie": imię = wartość; break;
                        case "Nazwisko": nazwisko = wartość; break;
                        case "Wiek": wiek = int.Parse(wartość); break;
                        case "NumerTelefonu": numerTelefonu = int.Parse(wartość); break;
                    }
                }
                osoby[i] = new Osoba(id, imię, nazwisko, wiek, numerTelefonu);
            }
            return osoby;
        }
    }
}