﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Views;

namespace XamarinApp1
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        //private Button przycisk;
        private TextView etykieta;
        private ListView lista;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            //przycisk = (Button)FindViewById(Resource.Id.button1);
            //przycisk = FindViewById<Button>(Resource.Id.button1);
            //przycisk.Click += (object sender, System.EventArgs e) => { Toast.MakeText(this, "Hello, World!", ToastLength.Long).Show(); };

            etykieta = FindViewById<TextView>(Resource.Id.textView1);
            lista = FindViewById<ListView>(Resource.Id.listView1);

            string[] łańcuchy = new string[]
            {
                "tekst1",
                "tekst2",
                "tekst3",
                "tekst4"
            };
            ArrayAdapter<string> adapter = new ArrayAdapter<string>(this, Android.Resource.Layout.SimpleListItem1, łańcuchy);
            lista.Adapter = adapter;

            lista.ItemClick += lista_ItemClick;
        }

        private void lista_ItemClick(object sender, AdapterView.ItemClickEventArgs e)
        {
            Toast.MakeText(
                this, 
                "Kliknięcie elementu: " + e.Position + " (" + (e.View as TextView).Text + ")", 
                ToastLength.Short).Show();
        }

        [Java.Interop.Export("Przycisk_Click")]
        public void Przycisk_Click(View v)
        {
            Toast.MakeText(this, "Halo Świecie!", ToastLength.Long).Show();
        }
}
}