﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Media;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace Uslugi
{
    [Service]
    class Usluga : Service
    {
        public override IBinder OnBind(Intent intent)
        {
            return null;
        }

        public static bool CzyUtworzona { get; private set; } = false;

        private Java.Util.Timer timer;
        private static Toast toastDlaTimera;

        private static ToneGenerator tg = new ToneGenerator(Stream.Alarm, 100);

        class Zadanie : Java.Util.TimerTask
        {
            public override void Run()
            {
                string czas = DateTime.Now.ToLongTimeString();
                //toastDlaTimera.SetText("Usługa: " + czas);
                //toastDlaTimera.Show();                
                tg.StartTone(Tone.CdmaAlertCallGuard, 200);
            }
        }

        public override void OnCreate()
        {
            base.OnCreate();

            toastDlaTimera = Toast.MakeText(this, "", ToastLength.Short);

            timer = new Java.Util.Timer();
            timer.ScheduleAtFixedRate(new Zadanie(), 1000, 2000);

            CzyUtworzona = true;
            Toast.MakeText(this, "Usługa utworzona", ToastLength.Short).Show();
        }

        public override void OnDestroy()
        {            
            timer.Cancel();
            CzyUtworzona = false;
            Toast.MakeText(this, "Usługa zatrzymana", ToastLength.Short).Show();
            base.OnDestroy();            
        }

        [return: GeneratedEnum]
        public override StartCommandResult OnStartCommand(Intent intent, [GeneratedEnum] StartCommandFlags flags, int startId)
        {
            Toast.MakeText(this, "Usługa uruchomiona", ToastLength.Short).Show();
            return base.OnStartCommand(intent, flags, startId);
        }
    }
}