﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace Uslugi
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private Button button1, button2;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            button1 = FindViewById<Button>(Resource.Id.button1);
            button2 = FindViewById<Button>(Resource.Id.button2);
            button1.Click +=
                (object sender, System.EventArgs e) =>
                {
                    if (!Usluga.CzyUtworzona)
                    {
                        Toast.MakeText(this, "Uruchamiam usługę", ToastLength.Short).Show();
                        StartService(new Android.Content.Intent(this, typeof(Usluga)));
                    }
                    else Toast.MakeText(this, "Usługa już jest uruchomiona", ToastLength.Short).Show();
                };
            button2.Click +=
                (object sender, System.EventArgs e) =>
                {
                    if (Usluga.CzyUtworzona)
                    {
                        Toast.MakeText(this, "Zatrzymuję usługę", ToastLength.Short).Show();
                        StopService(new Android.Content.Intent(this, typeof(Usluga)));
                    }
                    else Toast.MakeText(this, "Usługa nie jest uruchomiona", ToastLength.Short).Show();
                };
        }
    }
}