﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;

namespace Wibracje
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        SeekBar suwak;
        Button przycisk1, przycisk2;
        Vibrator wibrator;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            suwak = FindViewById<SeekBar>(Resource.Id.seekBar1);
            przycisk1 = FindViewById<Button>(Resource.Id.button1);
            przycisk2 = FindViewById<Button>(Resource.Id.button2);

            przycisk1.Click += Przycisk1_Click;
            przycisk2.Click += Przycisk2_Click;

            wibrator = (Vibrator)GetSystemService(VibratorService);
        }

        private void Przycisk1_Click(object sender, System.EventArgs e)
        {
            if(!wibrator.HasVibrator)
            {
                long czas = suwak.Progress;
                wibrator.Vibrate(czas);
                //VibrationEffect ve = VibrationEffect.CreateOneShot(czas, VibrationEffect.DefaultAmplitude);
                //wibrator.Vibrate(ve);
            }            
        }

        private void Przycisk2_Click(object sender, System.EventArgs e)
        {
            if (!wibrator.HasVibrator)
            {
                wibrator.Cancel();
            }
        }
    }
}