﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Widget;

using System;
using System.Collections.Generic;

namespace Tcp
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true,
        WindowSoftInputMode = Android.Views.SoftInput.StateHidden)]
    public class MainActivity : AppCompatActivity
    {
        private TextView tvLokalneAdresyIp, tvStan;
        private EditText etAdres, etPort, etTekst;
        private Button btnPolacz, btnRozlacz, btnWyslij;        
        private ListView lvOdebraneWiadomosci;

        private void pokażAdresyIp()
        {
            List<string> ips = Tcp.AdresyIP.PobierzAdresyIp();
            string sips = "";
            foreach (string ip in ips) sips += ip + "\n";
            tvLokalneAdresyIp.Text = sips.TrimEnd('\n');
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {            
            base.OnCreate(savedInstanceState);                        
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            tvLokalneAdresyIp = FindViewById<TextView>(Resource.Id.tvLokalneAdresyIp);

            etAdres = FindViewById<EditText>(Resource.Id.etAdres);
            etPort = FindViewById<EditText>(Resource.Id.etPort);
            btnPolacz = FindViewById<Button>(Resource.Id.btnPolacz);
            btnRozlacz = FindViewById<Button>(Resource.Id.btnRozlacz);
            tvStan = FindViewById<TextView>(Resource.Id.tvStan);

            etTekst = FindViewById<EditText>(Resource.Id.etTekst);
            btnWyslij = FindViewById<Button>(Resource.Id.btnWyslij);

            lvOdebraneWiadomosci = FindViewById<ListView>(Resource.Id.lvOdebraneWiadomosci);

            btnPolacz.Click += btnPolacz_Click;
            btnRozlacz.Click += btnRozlacz_Click;
            btnWyslij.Click += btnWyslij_Click;

            pokażAdresyIp();
        }

        private void btnPolacz_Click(object sender, System.EventArgs e)
        {
        }

        private void btnRozlacz_Click(object sender, System.EventArgs e)
        {
        }

        private void btnWyslij_Click(object sender, System.EventArgs e)
        {
        }
    }
}