﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Media;

namespace Grafika2D
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true,
        ScreenOrientation = Android.Content.PM.ScreenOrientation.Landscape)]
    public class MainActivity : AppCompatActivity
    {
        private MediaPlayer mp = null;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(new MainActivityView(this, null));

            try
            {
                if(mp != null && mp.IsPlaying)
                {
                    mp.Stop();
                    mp.Reset();
                }
                else if(mp!=null)
                {
                    mp.Reset();
                    mp.Release();
                }

                //mp = MediaPlayer.Create(ApplicationContext, Resource.Raw.Frasier);

                Android.Net.Uri uri = Android.Net.Uri.Parse("file:///storage/emulated/0/Download/Frasier.mp3");
                //Android.Net.Uri uri = Android.Net.Uri.Parse("file:///sdcard/Frasier.mp3");
                //mp = MediaPlayer.Create(ApplicationContext, uri);
                mp = new MediaPlayer(); mp.SetDataSource(ApplicationContext, uri); mp.Prepare();

                mp.Completion +=
                    (object sender, System.EventArgs e) =>
                    {
                        Toast.MakeText(ApplicationContext, "Odtwarzanie zakończone", ToastLength.Short).Show();
                    };

                mp.Start();
            }
            catch(Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext, "Java: " + exc.Message, ToastLength.Long).Show();
            }
            catch(System.Exception exc)
            {
                Toast.MakeText(ApplicationContext, "Net: " + exc.Message, ToastLength.Long).Show();
            }
        }

        protected override void OnPause()
        {
            mp.Pause();
            base.OnPause();
        }

        protected override void OnResume()
        {
            mp.Start();
            base.OnResume();
        }

        protected override void OnDestroy()
        {
            mp.Stop();
            base.OnDestroy();
        }
    }
}