﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Content.Res;
using Android.Graphics;
using Android.OS;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;

namespace Grafika2D
{
    public class MainActivityView : View
    {
        private Paint paint;
        int szerokość, wysokość;
        private Rect prost1, prost2, prost3;
        private Path ścieżka;
        private Bitmap obraz;
        private Bitmap logo;
        Random rnd;

        public MainActivityView(Context context, IAttributeSet attrs) :
            base(context, attrs)
        {
            Initialize();
        }

        public MainActivityView(Context context, IAttributeSet attrs, int defStyle) :
            base(context, attrs, defStyle)
        {
            Initialize();
        }

        private void Initialize()
        {
            rnd = new Random();

            paint = new Paint(PaintFlags.AntiAlias);            

            szerokość = this.Width;
            wysokość = this.Height;
            Log.Debug("view.ctor", "szerokość: " + szerokość);
            Log.Debug("view.ctor", "wysokość: " + wysokość);

            SetBackgroundColor(Color.Navy);
        }

        protected override void OnSizeChanged(int w, int h, int oldw, int oldh)
        {
            base.OnSizeChanged(w, h, oldw, oldh);

            szerokość = this.Width;
            wysokość =  this.Height;
            Log.Debug("view.onSizeChanged", "szerokość: " + szerokość);
            Log.Debug("view.onSizeChanged", "wysokość: " + wysokość);

            prost1 = new Rect(0, wysokość / 2, szerokość, wysokość);
            prost2 = new Rect(szerokość / 10, wysokość / 3, 5 * szerokość / 10, 2 * wysokość / 3);
            prost3 = new Rect(7 * szerokość / 40, 9 * wysokość / 20, 5 * szerokość / 20, 2 * wysokość / 3);

            ścieżka = new Path();
            ścieżka.SetFillType(Path.FillType.EvenOdd);
            ścieżka.MoveTo(6 * szerokość / 80, wysokość / 3);
            ścieżka.LineTo(2 * szerokość / 10, wysokość / 6);
            ścieżka.LineTo(4 * szerokość / 10, wysokość / 6);
            ścieżka.LineTo(42 * szerokość / 80, wysokość / 3);
            ścieżka.LineTo(szerokość / 10, wysokość / 3);
            ścieżka.Close();

            try {
                obraz = BitmapFactory.DecodeResource(Resources, Resource.Drawable.SantaClaus);
                logo = BitmapFactory.DecodeResource(Resources, Resource.Drawable.Logo_WFAiIS);
            } catch (Exception ex) {
                Log.Error("view.onSizeChanged", "Obraz nie został wczytany.\n" + ex.Message);
            }
        }

        private long aktualnyCzas = -1, poprzedniCzas = -1;

        protected override void OnDraw(Canvas canvas)
        {
            base.OnDraw(canvas);

            paint.SetStyle(Paint.Style.FillAndStroke);
            paint.StrokeWidth = 3;

            {
                // Pełny Księżyc
                paint.Color = Color.LightGray;
                int x0 = 4 * szerokość / 5;
                int y0 = wysokość / 4;
                int r1 = wysokość / 8;
                int r2 = 2 * r1;
                canvas.DrawCircle(x0, y0, r1, paint);

                // ROgal Księżyc
                paint.Color = Color.Navy;
                x0 = (4 * szerokość / 5) + (int)(0.04 * szerokość);
                y0 = (wysokość / 4);
                canvas.DrawCircle(x0, y0, r1, paint);
            }

            // Leżący śnieg
            paint.Color = Color.White;
            canvas.DrawRect(prost1, paint);

            // Domek - fundamenty
            paint.Color = Color.Brown;
            canvas.DrawRect(prost2, paint);

            // Drzwi
            paint.Color = Color.SandyBrown;
            canvas.DrawRect(prost3, paint);

            // Klamka
            paint.Color = Color.Brown;
            canvas.DrawCircle(19 * szerokość / 80, 11 * wysokość / 20, 10, paint);

            // Okna
            int _x0 = 13 * szerokość / 40;
            int _y0 = 2 * wysokość / 5;
            paint.Color = Color.Yellow;
            for(int ix = 0; ix < 2; ++ix)
                for (int iy = 0; iy < 2; ++iy)
                {
                    int x1 = _x0 + ix * szerokość / 15;
                    int y1 = _y0 + iy * wysokość / 15;
                    int x2 = x1 + szerokość / 20;
                    int y2 = y1 + wysokość / 20;
                    canvas.DrawRect(new Rect(x1, y1, x2, y2), paint);
                }

            // Parapet
            int offset = wysokość / 8;
            paint.Color = Color.SandyBrown;
            canvas.DrawRect(new Rect(_x0 - (int)(0.01 * szerokość),
                    _y0 + offset,
                    (_x0 + szerokość / 15) + (szerokość / 20) + (int)(0.01 * szerokość),
                    _y0 + wysokość / 60 + offset),
                paint);

            // Dach
            paint.Color = Color.Black;
            canvas.DrawPath(ścieżka, paint);

            // Życzenia
            paint.Color = Color.Red;
            paint.TextSize = szerokość / 10;
            paint.SetTypeface(Typeface.CreateFromAsset(Context.Assets, "Fonts/GreatVibes-Regular.otf"));
            string text = "Merry Christmas!";
            canvas.DrawText(text, (float)(szerokość / 2) - paint.MeasureText(text) / 3.0F, (float)(70 * wysokość / 80), paint);

            // Śnieg na dachu
            paint.Color = Color.White;
            canvas.DrawOval(new RectF(16 * szerokość / 80,
                    12 * wysokość / 80,
                    21 * szerokość / 80,
                    14 * wysokość / 80),
                paint);
            canvas.DrawOval(new RectF(21 * szerokość / 80,
                    wysokość / 7,
                    32 * szerokość / 80,
                    wysokość / 5),
                paint);

            if (aktualnyCzas < 0)
            {
                aktualnyCzas = Java.Lang.JavaSystem.CurrentTimeMillis();
                poprzedniCzas = aktualnyCzas;
            }
            else
            {
                poprzedniCzas = aktualnyCzas;
                aktualnyCzas = Java.Lang.JavaSystem.CurrentTimeMillis();
            }

            // Mikołaj
            double f = 0.0005;
            {
                int x0 = szerokość / 2;
                int y0 = wysokość / 40;

                float wsp = (float)obraz.Height / obraz.Width;

                int dx = szerokość / 3;
                int dy = (int)(wsp * dx);

                int xs = (int)(szerokość / 8 * Ctn(f * aktualnyCzas));


                canvas.DrawBitmap(obraz,
                    null,
                    new Rect(x0 + xs, y0, x0 + dx + xs, y0 + dy),
                    paint);
                
            }

            // Logo
            {
                int x0 = szerokość / 80;
                int y0 = 62 * wysokość / 80;

                float wsp = (float)logo.Height / logo.Width;

                int dx = szerokość / 5;
                int dy = (int)(wsp * dx);
                canvas.DrawBitmap(logo, null, new Rect(x0, y0, x0 + dx, y0 + dy),
                    paint);
            }

            // Śnieg
            for (int i = 0; i < 10; i++)
            {
                int x0 = rnd.Next(0, szerokość);
                int y0 = rnd.Next(0, wysokość);
                int r1 = rnd.Next(1, wysokość / 35);

                paint.Color = Color.White;
                paint.SetStyle(Paint.Style.FillAndStroke);
                canvas.DrawCircle(x0, y0, r1, paint);

                paint.Color = Color.Black;
                paint.SetStyle(Paint.Style.Stroke);
                canvas.DrawCircle(x0, y0, r1, paint);

                paint.SetStyle(Paint.Style.FillAndStroke);
            }

            Invalidate();
        }

        private double Ctn(double x)
        {
            return 1.0 / Math.Tan(x);
        }
    }
}