using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.Graphics;
using Android.OS;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;

namespace Grafika2D
{
    public class MainActivityView : View
    {
        private Paint paint;
        int szeroko, wysoko;

        public MainActivityView(Context context, IAttributeSet attrs) :
            base(context, attrs)
        {
            Initialize();
        }

        public MainActivityView(Context context, IAttributeSet attrs, int defStyle) :
            base(context, attrs, defStyle)
        {
            Initialize();
        }

        private void Initialize()
        {
            paint = new Paint(PaintFlags.AntiAlias);            

            szeroko = this.Width;
            wysoko = this.Height;
            Log.Debug("view.ctor", "szeroko: " + szeroko);
            Log.Debug("view.ctor", "wysoko: " + wysoko);

            SetBackgroundColor(Color.DarkBlue);
        }

        protected override void OnSizeChanged(int w, int h, int oldw, int oldh)
        {
            base.OnSizeChanged(w, h, oldw, oldh);

            szeroko = this.Width;
            wysoko =  this.Height;
            Log.Debug("view.onSizeChanged", "szeroko: " + szeroko);
            Log.Debug("view.onSizeChanged", "wysoko: " + wysoko);

            
        }


        //private long aktualnyCzas = -1, poprzedniCzas = -1;
        int growUp = 1;
        protected override void OnDraw(Canvas canvas)
        {
            base.OnDraw(canvas);

            paint.SetStyle(Paint.Style.FillAndStroke);
            paint.StrokeWidth = 3;
            growUp = (growUp+1) % 3 + 1; //
            //kula ziemska
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = szeroko/2;
                int y0 = wysoko*2;
                int r1 = (int)(wysoko*1.5);
                canvas.DrawCircle(x0, y0, r1, paint);

            }

            //ksiezyc logo
            paint.Color = Color.LightGray; //najwieksze kolo
            {
                int x0 = (int)(szeroko* 0.9);
                int y0 = wysoko / 4;
                int r1 = wysoko / 10;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //srodek
            paint.Color = Color.White;
            {
                int x0 = (int)(szeroko * 0.9);
                int y0 = wysoko / 4;
                int r1 = wysoko / 30;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //wyciecie
            paint.Color = Color.DarkBlue;
            {
                int x0 = (int)(szeroko * 0.88);
                int y0 = wysoko / 4 - wysoko / 10;
                int r1 = wysoko / 23;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            // mala kulka
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.88);
                int y0 = wysoko / 4 - wysoko / 10;
                int r1 = wysoko / 50;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            paint.Color = Color.DarkBlue;
            paint.SetTypeface(Typeface.SansSerif);
            paint.StrokeWidth = 1;
            paint.TextSize = 35;
            {
                string text = "WFAiIS";
                int x0 = (int)(szeroko * 0.45);
                int y0 = (int)(wysoko * 0.60);
                canvas.DrawText(text, x0, y0, paint);
            }
            paint.StrokeWidth = 1;
            paint.TextSize = 20;
            {
                string text = "şyczy";
                int x0 = (int)(szeroko * 0.475);
                int y0 = (int)(wysoko * 0.66);
                canvas.DrawText(text, x0, y0, paint);
            }

	// napis zmiana
            paint.StrokeWidth = 5;
            paint.TextSize = 150 + growUp * 2;
            Typeface havana = Typeface.CreateFromAsset(Context.Assets, "Havana.ttf");
            paint.SetTypeface(Typeface.Create(havana, TypefaceStyle.Normal));
            {
                string text = "Weso?ych ?wi?t!";
                int x0 = (int)(szeroko*0.13)- growUp * 4;
                int y0 = (int)(wysoko * 0.9);
                canvas.DrawText(text, x0, y0, paint);
            }
	// gwiazdy zmiana rozmiaru
            paint.StrokeWidth = 5 + growUp * 4;

            //gwiazdy
            //orion
            //1 duza gorna z lewej
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.08);
                int y0 = (int)(wysoko * 0.15);
                int r1 = wysoko /120;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //2 duza gorna z prawej
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.17);
                int y0 = (int)(wysoko * 0.20);
                int r1 = wysoko / 180;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //3 mala z gory
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.15);
                int y0 = (int)(wysoko * 0.11);
                int r1 = wysoko / 300;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //srodkowe
            //lewa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.11);
                int y0 = (int)(wysoko * 0.365);
                int r1 = wysoko / 500;
                canvas.DrawCircle(x0, y0, r1, paint);
            }//srodkowa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.13);
                int y0 = (int)(wysoko * 0.35);
                int r1 = wysoko / 500;
                canvas.DrawCircle(x0, y0, r1, paint);
            }//prawa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.15);
                int y0 = (int)(wysoko * 0.335);
                int r1 = wysoko / 500;
                canvas.DrawCircle(x0, y0, r1, paint);
            }

            //dolne
            //1 duza z lewej
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.10);
                int y0 = (int)(wysoko * 0.55);
                int r1 = wysoko / 200;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //2 duza z prawej
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.18);
                int y0 = (int)(wysoko * 0.55);
                int r1 = wysoko / 200;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //maly woz
            //gora lewa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.38);
                int y0 = (int)(wysoko * 0.19);
                int r1 = wysoko / 200;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //gora prawa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.45);
                int y0 = (int)(wysoko * 0.15);
                int r1 = wysoko / 300;
                canvas.DrawCircle(x0, y0, r1, paint);
            }//dol lewa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.41);
                int y0 = (int)(wysoko * 0.30);
                int r1 = wysoko / 200;
                canvas.DrawCircle(x0, y0, r1, paint);
            }//dol prawa
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.46);
                int y0 = (int)(wysoko * 0.24);
                int r1 = wysoko / 300;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //ogon 1
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.53);
                int y0 = (int)(wysoko * 0.22);
                int r1 = wysoko / 300;
                canvas.DrawCircle(x0, y0, r1, paint);
            }//ogon 2
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.60);
                int y0 = (int)(wysoko * 0.28);
                int r1 = wysoko / 300;
                canvas.DrawCircle(x0, y0, r1, paint);
            }
            //ogon 3
            paint.Color = Color.WhiteSmoke;
            {
                int x0 = (int)(szeroko * 0.65);
                int y0 = (int)(wysoko * 0.37);
                int r1 = wysoko / 150;
                canvas.DrawCircle(x0, y0, r1, paint);
            }

            Invalidate();
            System.Threading.Thread.Sleep(100);
            //doda? FPS!!!
        }
    }
}