package pl.umk.fizyka.grafika3d;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import android.opengl.GLUtils;
import android.os.Bundle;
import android.view.Menu;

public class MainActivity extends Activity 
{
	GLSurfaceView glView;
	
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_main); //plik XML jest niepotrzebny!!!
        
        glView = new GLSurfaceView(this);
        glView.setRenderer(new OpenGLRenderer(getApplicationContext()));
   		setContentView(glView);
    }
    
    @Override
    protected void onPause() 
    {
       super.onPause();
       glView.onPause();
    }
    
    // Call back after onPause()
    @Override
    protected void onResume() 
    {
       super.onResume();
       glView.onResume();
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}

class OpenGLRenderer implements android.opengl.GLSurfaceView.Renderer
{
	Context context;
	final boolean teksturowanie = true;
	//Uwaga! Oba rozmiary tekstury powinny by potgami dwjki np. 256x256
	
	public OpenGLRenderer(Context context)
	{
		this.context=context;
	}
	
	public void onSurfaceCreated(GL10 gl, EGLConfig config) 
	{
		gl.glShadeModel(GL10.GL_SMOOTH);
		
		//ustawienia testu glebii (takie, jak domylne)
		gl.glClearDepthf(1.0f);
		gl.glEnable(GL10.GL_DEPTH_TEST);
		gl.glDepthFunc(GL10.GL_LEQUAL);
		gl.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT, GL10.GL_NICEST);
		
		gl.glDisable(GL10.GL_DITHER);
		
		inicjujBuforWerteksow();
		
		if(teksturowanie)
		{
			loadTexture(gl, context);
			gl.glEnable(GL10.GL_TEXTURE_2D);
		}
		else gl.glDisable(GL10.GL_TEXTURE_2D);
	}

	private void ustawienieSceny(GL10 gl,int szer,int wys)
	{
		gl.glViewport(0, 0, szer, wys);
		
		gl.glMatrixMode(GL10.GL_PROJECTION); //przeczenie na macierz projekcji
		gl.glLoadIdentity();
		//left,right,bottom,top,znear,zfar (clipping)
		//float wsp=wys/(float)szer;		
		//gl.glFrustumf(-0.1f, 0.1f, wsp*-0.1f, wsp*0.1f, 0.3f, 100.0f);
		GLU.gluPerspective(gl, 45.0f, (float)szer/(float)wys, 0.1f, 100.0f);
		gl.glMatrixMode(GL10.GL_MODELVIEW); //powrt do macierzy widoku modelu
		gl.glLoadIdentity();
		GLU.gluLookAt(
				gl, 
				0, 0, 7.5f, //polozenie kamery 
				0, 0, 0, //cel 
				0, 1, 0); //polaryzacja		
	}
	
	float natezenie_swiatla_otoczenia = 0.3f;
	
	private void oswietlenie(GL10 gl)
	{
	   gl.glEnable(GL10.GL_LIGHTING); //wlaczenie systemu oswietlania

	   //nie ma color-material, wiec kolory w werteksach sa ignorowane (tylko tekstury)
	   
	   //rda wiata
	   mlecznaZarowka(gl,GL10.GL_LIGHT1);
	   reflektor(gl,GL10.GL_LIGHT2);

	   //mieszanie kolorow
	   //gl.glEnable(GL10.GL_BLEND);
	   //gl.glBlendFunc(GL10.GL_SRC_ALPHA,GL10.GL_ONE_MINUS_SRC_ALPHA);
	}

	private void mlecznaZarowka(GL10 gl,int zrodloSwiatla)
	{
	   final float kolor1_rozproszone[]={0.5f,0.5f,0.5f,1.0f};
	   gl.glLightfv(zrodloSwiatla,GL10.GL_DIFFUSE,kolor1_rozproszone,0);
	   gl.glEnable(zrodloSwiatla);
	}

	private void reflektor(GL10 gl,int zrodloSwiatla)
	{
	   final float kolor_rozproszone[]={0.3f,0.3f,0.3f,1.0f};
	   final float kolor_reflektora[]={1.0f,1.0f,1.0f,1.0f};
	   final float pozycja[]={0.0f,-10.0f,10.0f,1.0f};
	   final float szerokosc_wiazki=60.0f; //w stopniach
	   gl.glLightfv(zrodloSwiatla,GL10.GL_POSITION,pozycja,0);
	   gl.glLightfv(zrodloSwiatla,GL10.GL_DIFFUSE,kolor_rozproszone,0);
	   gl.glLightfv(zrodloSwiatla,GL10.GL_SPECULAR,kolor_reflektora,0);
	   gl.glLightf(zrodloSwiatla,GL10.GL_SPOT_CUTOFF,szerokosc_wiazki);
	   gl.glEnable(zrodloSwiatla);
	}
	
	public void onSurfaceChanged(GL10 gl, int width, int height) 
	{
		if (height == 0) height = 1;
		ustawienieSceny(gl,width,height);
		oswietlenie(gl);
	}
	
	final float a = 1f;
	private float[] tablicaWerteksow = 
	{
		//tylnia
		a,-a,-a,
		-a,-a,-a,
		a,a,-a,
		-a,a,-a,
		//przednia
		-a,-a,a,
		a,-a,a,
		-a,a,a,
		a,a,a,				

		//prawa
		a,-a,a,
		a,-a,-a,
		a,a,a,
		a,a,-a,
		//lewa
		-a,-a,-a,
		-a,-a,a,
		-a,a,-a,
		-a,a,a,
		
		//gorna
		-a,a,a,
		a,a,a,
		-a,a,-a,
		a,a,-a,
		//dolna
		-a,-a,-a,
		a,-a,-a,
		-a,-a,a,
		a,-a,a
	};
	
	private FloatBuffer buforWerteksow_Polozenia;
	private FloatBuffer buforWerteksow_WspTeksturowania;
	
	private void inicjujBuforWerteksow()
	{
		ByteBuffer vbb = ByteBuffer.allocateDirect(tablicaWerteksow.length * 4); //float = 4 bajty
	    vbb.order(ByteOrder.nativeOrder()); // Use native byte order
	    buforWerteksow_Polozenia = vbb.asFloatBuffer(); // Convert from byte to float
	    buforWerteksow_Polozenia.put(tablicaWerteksow);         // Copy data into buffer
	    buforWerteksow_Polozenia.position(0);           // Rewind
	    
	    if(teksturowanie)
	    {
	    	ByteBuffer tbb = ByteBuffer.allocateDirect(texCoords.length * 4);
	    	tbb.order(ByteOrder.nativeOrder());
	    	buforWerteksow_WspTeksturowania = tbb.asFloatBuffer();
	    	buforWerteksow_WspTeksturowania.put(texCoords);
	    	buforWerteksow_WspTeksturowania.position(0);
	    }
	}

	float normalne[][] =
	{
		{0f,0f,-1f}, //tylnia
		{0f,0f,1f}, //przednia
		{1f,0f,0f}, //prawa
		{-1f,0f,0f}, //lewa
		{0f,1f,0f}, //gorna
		{0f,-1f,0f} //dolna
	};
	
	float kolory[][] =
	{
		{1f,0f,0f,1f}, //tylnia
		{1f,0f,0f,1f}, //przednia
		{0f,1f,0f,1f}, //prawa
		{0f,1f,0f,1f}, //lewa
		{0f,0f,1f,1f}, //gorna
		{0f,0f,1f,1f} //dolna
	};
	
	float[] texCoords = 
	{ 
		//tylnia
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f,
		//przednia
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f,
		//prawa
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f,
		//lewa
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f,
		//gorna
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f,
		//dolna
		0.0f, 1.0f,
		1.0f, 1.0f,
		0.0f, 0.0f,
		1.0f, 0.0f
	};
	int[] textureIDs = new int[1];   // Array for 1 texture-ID (NEW)
	
	public void loadTexture(GL10 gl, Context context) 
	{
	      gl.glGenTextures(1, textureIDs, 0); // Generate texture-ID array

	      gl.glBindTexture(GL10.GL_TEXTURE_2D, textureIDs[0]);   // Bind to texture ID
	      // Set up texture filters
	      gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_MIN_FILTER, GL10.GL_NEAREST);
	      gl.glTexParameterf(GL10.GL_TEXTURE_2D, GL10.GL_TEXTURE_MAG_FILTER, GL10.GL_LINEAR);
	  
	      // Construct an input stream to texture image "res\drawable\nehe.png"
	      InputStream istream = context.getResources().openRawResource(R.drawable.tekstura);
	      Bitmap bitmap;
	      try 
	      {
	         // Read and decode input as bitmap
	         bitmap = BitmapFactory.decodeStream(istream);
	      } 
	      finally 
	      {
	         try 
	         {
	            istream.close();
	         } 
	         catch(IOException e) 
	         { }
	      }
	  
	      // Build Texture from loaded bitmap for the currently-bind texture ID
	      GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bitmap, 0);
	      bitmap.recycle();
	   }

	
	private void rysujSzescian(GL10 gl,float krawedz,boolean kolor)
	{
		gl.glFrontFace(GL10.GL_CCW);    // Front face in counter-clockwise orientation
	    gl.glEnable(GL10.GL_CULL_FACE); // Enable cull face
	    gl.glCullFace(GL10.GL_BACK); 
	    
		if(krawedz!=1.0f) gl.glScalef(krawedz, krawedz, krawedz);

		gl.glEnableClientState(GL10.GL_VERTEX_ARRAY);		
		gl.glVertexPointer(3, GL10.GL_FLOAT, 0, buforWerteksow_Polozenia);
		
		if(teksturowanie)
		{
			gl.glEnableClientState(GL10.GL_TEXTURE_COORD_ARRAY);		
			gl.glTexCoordPointer(2, GL10.GL_FLOAT, 0, buforWerteksow_WspTeksturowania);
		}

		if(!kolor) gl.glColor4f(1f, 1f, 1f, 1f);
		
		for(int i=0;i<6;++i)
		{
			gl.glNormal3f(normalne[i][0], normalne[i][1], normalne[i][2]);
			if(kolor) gl.glColor4f(kolory[i][0], kolory[i][1], kolory[i][2], kolory[i][3]);
			gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, i*4, 4);
		}
	    
		gl.glDisableClientState(GL10.GL_TEXTURE_COORD_ARRAY);  
	    gl.glDisableClientState(GL10.GL_VERTEX_ARRAY);
	    gl.glDisable(GL10.GL_CULL_FACE);
	}

	public void onDrawFrame(GL10 gl) 
	{
		gl.glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);

		gl.glRotatef(1, 1, 3, 0);
		
		//gl.glPushMatrix(); //zapamietaj macierz model-widok (wloz na stos macierzy)		
		rysujSzescian(gl,1.0f,true);
		//gl.glPopMatrix(); //zdejmij ze stosu macierzy = odtworz zapamietany stan
	}
}
