﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Widget;

using System;
using System.Collections.Generic;
using Android.Content;
using Android.Util;
using Umk.Ntpp;

namespace Tcp
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true,
        WindowSoftInputMode = Android.Views.SoftInput.StateHidden)]
    public class MainActivity : AppCompatActivity
    {
        private TextView tvStan;
        private EditText etTekst;
        private Button btnPolacz, btnRozlacz, btnWyslij;
        private ListView lvOdebraneWiadomosci, lvDevices;
        private ArrayAdapter devicesListAdapter;

        private NtppClient ntppClient;
        private List<string> devices;
        
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            lvDevices = FindViewById<ListView>(Resource.Id.lvDevices);
            devices = new List<string>();
            devicesListAdapter = new ArrayAdapter(this, Android.Resource.Layout.SimpleExpandableListItem1, devices);
            lvDevices.Adapter = devicesListAdapter;

            btnPolacz = FindViewById<Button>(Resource.Id.btnPolacz);
            btnRozlacz = FindViewById<Button>(Resource.Id.btnRozlacz);
            tvStan = FindViewById<TextView>(Resource.Id.tvStan);

            etTekst = FindViewById<EditText>(Resource.Id.etTekst);
            btnWyslij = FindViewById<Button>(Resource.Id.btnWyslij);

            lvOdebraneWiadomosci = FindViewById<ListView>(Resource.Id.lvOdebraneWiadomosci);

            btnPolacz.Click += btnPolacz_Click;
            btnRozlacz.Click += btnRozlacz_Click;
            btnWyslij.Click += btnWyslij_Click;

            //pokażAdresyIp();

            ntppClient = new NtppClient(Build.Model);
            ntppClient.StateChanged += ntppClient_StateChanged;
            ntppClient.TextReceived += ntppClient_TextReceived;
            ntppClient.DeviceFound += ntppClient_DeviceFound;
        }

        private void ntppClient_StateChanged(object sender, NtppClient.StateChangedEventArgs e)
        {
            Action a = () => { tvStan.Text = e.NewState.ToString(); };
            this.RunOnUiThread(a);
        }

        private void ntppClient_DeviceFound(object sender, NtppClient.DeviceFoundArgs e)
        {
            string value = e.Name + " (" + e.IpAddress.ToString() + ")";

            if (!devices.Contains(value))
            {
                RunOnUiThread(() =>
                {
                    devices.Add(value);
                    devicesListAdapter.Add(value);
                    devicesListAdapter.NotifyDataSetChanged();
                });
                Log.Debug("BCAST", e.Name + " " + e.IpAddress);
            }
        }

        private List<string> odebraneWiadomości = new List<string>();

        private void pokażOdebraneWiadomości()
        {
            try
            {
                ArrayAdapter<string> adapter = new ArrayAdapter<string>(
                    this,
                    Android.Resource.Layout.SimpleExpandableListItem1,
                    odebraneWiadomości);
                lvOdebraneWiadomosci.Adapter = adapter;
                //scroll down to end
                lvOdebraneWiadomosci.Post(() => lvOdebraneWiadomosci.SetSelection(adapter.Count - 1));
            }
            catch (Exception exc)
            {
                Toast.MakeText(this, "Błąd: " + exc.Message, ToastLength.Long).Show();
            }
        }

        private void ntppClient_TextReceived(object sender, NtppClient.TextReceivedEventArgs e)
        {
            odebraneWiadomości.Add(e.ReceivedFrom.Hostname + " (" + DateTime.Now.ToString() + "): " + e.ReceivedText);
            Action a = () => { pokażOdebraneWiadomości(); };
            this.RunOnUiThread(a);
        }

        private void btnPolacz_Click(object sender, System.EventArgs e)
        {
            if (lvDevices.Count == 0)
            {
                Toast.MakeText(this, "Błąd: Nie znaleziono żadnych urządzeń", ToastLength.Long).Show();
                return;
            }
            if (lvDevices.CheckedItemPosition == -1)
            {
                Toast.MakeText(this, "Błąd: Nie wybrano żadnego urządzenia z listy", ToastLength.Long).Show();
                return;
            }
            try
            {
                string selectedItem = (string)devicesListAdapter.GetItem(lvDevices.CheckedItemPosition);
                int addrStartIndex = selectedItem.IndexOf("(");
                int addrEndIndex = selectedItem.IndexOf(")");
                string address = selectedItem.Substring(addrStartIndex + 1, addrEndIndex - addrStartIndex - 1);

                NtppConnectionData connectionData = new NtppConnectionData()
                {
                    Hostname = address
                };
                ntppClient.Connect(connectionData);
            }
            catch (Exception exc)
            {
                Toast.MakeText(this, "Błąd: " + exc.Message, ToastLength.Long).Show();
            }
        }

        private void btnRozlacz_Click(object sender, System.EventArgs e)
        {
            try
            {
                ntppClient.Disconnect();
            }
            catch (Exception exc)
            {
                Toast.MakeText(this, "Błąd: " + exc.Message, ToastLength.Long).Show();
            }
        }

        private void btnWyslij_Click(object sender, System.EventArgs e)
        {
            ntppClient.SendText(etTekst.Text);
        }

        //protected override void OnDestroy()
        //{
        //    ntppClient.StateChanged -= ntppClient_StateChanged;
        //    ntppClient.TextReceived -= ntppClient_TextReceived;

        //    btnRozlacz_Click(this, EventArgs.Empty);

        //    base.OnDestroy();
        //}

        public void DisposeNtpp()
        {
            btnRozlacz_Click(this, EventArgs.Empty);

            ntppClient.StateChanged -= ntppClient_StateChanged;
            ntppClient.TextReceived -= ntppClient_TextReceived;
            ntppClient.DeviceFound -= ntppClient_DeviceFound;
        }
    }
}