﻿using Android.App;
using Android.Graphics;
using Android.Graphics.Drawables;
using Android.Graphics.Drawables.Shapes;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Util;
using Android.Widget;
using Java.Lang;

namespace Kolory
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private TextView etykieta_panel;
        private SeekBar seekBarR, seekBarG, seekBarB;
        private Spinner spinner;

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            etykieta_panel = FindViewById<TextView>(Resource.Id.etykieta_panel);

            seekBarR = FindViewById<SeekBar>(Resource.Id.seekBarR);
            seekBarG = FindViewById<SeekBar>(Resource.Id.seekBarG);
            seekBarB = FindViewById<SeekBar>(Resource.Id.seekBarB);

            seekBarR.ProgressChanged += seekBar_ProgressChanged;
            seekBarG.ProgressChanged += seekBar_ProgressChanged;
            seekBarB.ProgressChanged += seekBar_ProgressChanged;

            //zmiana wygladu suwakow
            float promien = 16;
            float[] promienie = {promien, promien, promien, promien, promien, promien, promien, promien};
            RoundRectShape rrs = new RoundRectShape(promienie, null, null);

            ShapeDrawable sdR = new ShapeDrawable(rrs);
            sdR.Paint.SetShader(new LinearGradient(0, 0, 600, 0, Color.Transparent, Color.Red, Shader.TileMode.Clamp));
            seekBarR.ProgressDrawable = sdR;

            ShapeDrawable sdG = new ShapeDrawable(rrs);
            sdG.Paint.SetShader(new LinearGradient(0, 0, 600, 0, Color.Transparent, Color.Green, Shader.TileMode.Clamp));
            seekBarG.ProgressDrawable = sdG;

            ShapeDrawable sdB = new ShapeDrawable(rrs);
            sdB.Paint.SetShader(new LinearGradient(0, 0, 600, 0, Color.Transparent, Color.Blue, Shader.TileMode.Clamp));
            seekBarB.ProgressDrawable = sdB;

            //rozwijana lista
            spinner = FindViewById<Spinner>(Resource.Id.spinner);
            ArrayAdapter adapter2 = ArrayAdapter.CreateFromResource(this, Resource.Array.kolory, Android.Resource.Layout.SimpleSpinnerItem);
            adapter2.SetDropDownViewResource(Android.Resource.Layout.SimpleSpinnerDropDownItem);
            spinner.Adapter = adapter2;
            spinner.ItemSelected += spinner_ItemSelected;
        }

        private void spinner_ItemSelected(object sender, AdapterView.ItemSelectedEventArgs e)
        {
            switch (e.Position)
            {
                case 0:
                    break;
                case 1:
                    seekBarR.Progress = seekBarG.Progress = seekBarB.Progress = 0;
                    break;
                case 2:
                    seekBarR.Progress = seekBarG.Progress = seekBarB.Progress = 255;
                    break;
            }
        }

        private void seekBar_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            int r = seekBarR.Progress;
            int g = seekBarG.Progress;
            int b = seekBarB.Progress;

            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));

            etykieta_panel.Text = "Skladowe koloru: " + 
                                  r.ToString("X2").ToUpper() + 
                                  g.ToString("X2").ToUpper() +
                                  b.ToString("X2").ToUpper();

            int jasnosc = (int)(0.2126 * r + 0.7152 * g + 0.0722 * b);
            etykieta_panel.SetTextColor(jasnosc > 127 ? Color.Black : Color.White);

            spinner.SetSelection(0);
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }
}