﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.Database.Sqlite;
using Android.Database;
using System.Reflection;

namespace SQLiteDatabase
{
    //zrobic klasę parametryczną
    public class PeopleDatabase : SQLiteOpenHelper
    {
        public const string DBName = "people.db";

        public PeopleDatabase(Context context) : base(context, DBName, null, 1)
        {
        }

        public override void OnCreate(Android.Database.Sqlite.SQLiteDatabase db)
        {
            //tworzy bazę
            string createCommand = $"create table {DBModel.Person.TableName} (";
            for (int columnNumber = 0; columnNumber < DBModel.Person.TableColumnNames.Length; columnNumber++)
            {
                string columnName = DBModel.Person.TableColumnNames[columnNumber];
                string columnProperty = DBModel.Person.TableColumnProperties[columnNumber];
                createCommand += columnName + " " + columnProperty + ",";
            }
            createCommand = createCommand.TrimEnd(',');
            createCommand += ")";

            db.ExecSQL(createCommand);
        }

        public override void OnUpgrade(Android.Database.Sqlite.SQLiteDatabase db, int oldVersion, int newVersion)
        {
            //zmiana wersji

        }

        private ContentValues PersonValues(DBModel.Person person)
        {
            ContentValues values = new ContentValues();
            values.Put(DBModel.Person.TableColumnNames[0], person.Id);
            values.Put(DBModel.Person.TableColumnNames[1], person.FirstName);
            values.Put(DBModel.Person.TableColumnNames[2], person.LastName);
            values.Put(DBModel.Person.TableColumnNames[3], person.Age);
            values.Put(DBModel.Person.TableColumnNames[4], person.PhoneNumber);

            return values;
        }

        public void AddRecord(DBModel.Person person)
        {
            ContentValues values = PersonValues(person);
            var db = WritableDatabase;
            db.InsertOrThrow(DBModel.Person.TableName, null, values);
        }

        private static DBModel.Person PersonFromCarriage(ICursor carriage)
        {
            DBModel.Person person = new DBModel.Person(carriage.GetInt(0), carriage.GetString(1), carriage.GetString(2), carriage.GetInt(3), carriage.GetInt(4));
            return person;
        }

        public DBModel.Person[] GetAllRecords(string orderBy)
        {
            var db = ReadableDatabase;
            ICursor carriage = db.Query(DBModel.Person.TableName, DBModel.Person.TableColumnNames, null, null, null, null, orderBy);
            List<DBModel.Person> list = new List<DBModel.Person>();
            while (carriage.MoveToNext())
            {
                list.Add(PersonFromCarriage(carriage));
            }

            carriage.Close();

            DBModel.Person[] table = list.ToArray();
            return table;
        }

        public DBModel.Person[] GetAllRecords()
        {
            return GetAllRecords(null);
        }

        public DBModel.Person GetById(int id)
        {
            var db = this.ReadableDatabase;
            DBModel.Person person = GetAllRecords().SingleOrDefault(x => x.Id == id);
            return person;
        }

        public bool DeleteRecord(int id)
        {
            Android.Database.Sqlite.SQLiteDatabase db = this.WritableDatabase;
            string[] whereArgs = { id.ToString() };
            return db.Delete(DBModel.Person.TableName, "Id=?", whereArgs) > 0;
        }

        public bool UpdateRecord(int id, DBModel.Person person)
        {
            Android.Database.Sqlite.SQLiteDatabase db = this.WritableDatabase;
            ContentValues values = PersonValues(person);
            string[] whereArgs = { id.ToString() };
            return db.Update(DBModel.Person.TableName, values, "Id=?", whereArgs) > 0;
        }
    }
}