﻿using PierwszaAplikacjaMAUI.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PierwszaAplikacjaMAUI.ModelWidoku
{
    internal class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor model = KolorHelper.OdczytajStanZPliku();

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R), nameof(Kolor));                
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G), nameof(Kolor));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B), nameof(Kolor));
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        private void onPropertyChanged(params string[] propertyNames)
        {
            //model.ZapiszStanDoPliku(); //TODO: to nie może tak zostać!!!!
            if (PropertyChanged != null)
                foreach (string propertyName in propertyNames)
                {
                    PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
                }
        }

        //tymczasowe
        public Color Kolor
        {
            get
            {
                return new Color(R, G, B);                
            }
        }
    }
}
