﻿using PierwszaAplikacjaMAUI.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace PierwszaAplikacjaMAUI.ModelWidoku
{
    internal class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor model = KolorHelper.OdczytajStanZPliku();

        public byte R
        {
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                onPropertyChanged(nameof(R), nameof(Kolor));                
            }
        }

        public byte G
        {
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                onPropertyChanged(nameof(G), nameof(Kolor));
            }
        }

        public byte B
        {
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                onPropertyChanged(nameof(B), nameof(Kolor));
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        private void onPropertyChanged(params string[] propertyNames)
        {
            //model.ZapiszStanDoPliku(); //TODO: to nie może tak zostać!!!!
            if (PropertyChanged != null)
                foreach (string propertyName in propertyNames)
                {
                    PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
                }
        }

        //tymczasowe
        public Color Kolor
        {
            get
            {
                return new Color(R, G, B);                
            }
        }

        class PolecenieResetowania : ICommand
        {
            public event EventHandler? CanExecuteChanged; //TODO: przestać ignorować

            private EdycjaKoloru ek;
            private bool poprzedniaWartośćCanExecute;

            public PolecenieResetowania(EdycjaKoloru ek)
            {                
                this.ek = ek;
                poprzedniaWartośćCanExecute = CanExecute(false);
                ek.PropertyChanged += zmieniłSięKolor;
            }

            private void zmieniłSięKolor(object? sender, PropertyChangedEventArgs e)
            {
                bool bieżącaWartość = CanExecute(null);
                if(CanExecuteChanged != null && bieżącaWartość != poprzedniaWartośćCanExecute)
                {
                    CanExecuteChanged(this, EventArgs.Empty);
                }
                poprzedniaWartośćCanExecute = bieżącaWartość;
            }

            public bool CanExecute(object? parameter)
            {
                return (ek.R != 0) || (ek.G != 0) || (ek.B != 0);
            }

            public void Execute(object? parameter)
            {
                ek.R = 0;
                ek.G = 0;
                ek.B = 0;
            }
        }

        private ICommand resetowanie = null;

        public ICommand Resetowanie
        {
            get
            {
                if (resetowanie == null) resetowanie = new PolecenieResetowania(this);
                return resetowanie;
            }
        }
    }
}
