﻿namespace SyntezaMowy
{
    public partial class MainPage : ContentPage
    {
        public MainPage()
        {
            InitializeComponent();

            pobierzGłosy();
        }

        private int indeksWybranegoGłosu = 0;
        private Locale[] tablicaGłosów;

        private async void pobierzGłosy()
        {
            IEnumerable<Locale> głosy = await TextToSpeech.GetLocalesAsync();
            tablicaGłosów = głosy.ToArray();
            lvGłosy.ItemsSource = tablicaGłosów.Select(g => g.Name);

            if (tablicaGłosów.Length > 0)
            {
                indeksWybranegoGłosu = 0;
                lvGłosy.SelectedItem = tablicaGłosów[0].Name;
                btnCzytaj.IsEnabled = true;
            }
            else btnCzytaj.IsEnabled = false;
        }

        private void lvGłosy_ItemSelected(object sender, SelectedItemChangedEventArgs e)
        {
            indeksWybranegoGłosu = e.SelectedItemIndex;
        }

        private async void btnCzytaj_Clicked(object sender, EventArgs e)
        {
            SpeechOptions so = new SpeechOptions();
            so.Volume = (float)slGłośność.Value;
            so.Pitch = (float)slTon.Value;
            so.Locale = tablicaGłosów[indeksWybranegoGłosu];
            string tekst = edTekst.Text;
            if (tekst.Length > 0)
                await TextToSpeech.Default.SpeakAsync(tekst, so);
        }
    }

}
