package pl.umk.fizyka.kolory;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.SeekBar;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
{
    private SeekBar seekBarR, seekBarG, seekBarB;
    private TextView etykieta_panel;

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        etykieta_panel = (TextView)findViewById(R.id.etykieta_panel);
        seekBarR = (SeekBar) findViewById(R.id.seekBarR);
        seekBarG = (SeekBar) findViewById(R.id.seekBarG);
        seekBarB = (SeekBar) findViewById(R.id.seekBarB);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        //seekBarR.setProgress(0);
        //seekBarG.setProgress(0);
        //seekBarB.setProgress(0);

        seekBarChangeListener.onProgressChanged(null, 0, true);

        float promień = 8;
        float[] promienie = { promień, promień, promień, promień, promień, promień, promień, promień };
        RoundRectShape rrs = new RoundRectShape(promienie, null, null);

        ShapeDrawable sdR = new ShapeDrawable(rrs);
        sdR.getPaint().setShader(
                new LinearGradient(
                        0,0,400,0,Color.BLACK,Color.RED, Shader.TileMode.CLAMP));
        seekBarR.setProgressDrawable(sdR);

        ShapeDrawable sdG = new ShapeDrawable(rrs);
        sdG.getPaint().setShader(
                new LinearGradient(
                        0,0,400,0,Color.BLACK,Color.GREEN, Shader.TileMode.CLAMP));
        seekBarG.setProgressDrawable(sdG);

        ShapeDrawable sdB = new ShapeDrawable(rrs);
        sdB.getPaint().setShader(
                new LinearGradient(
                        0,0,400,0,Color.BLACK,Color.BLUE, Shader.TileMode.CLAMP));
        seekBarB.setProgressDrawable(sdB);
    }

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener()
    {
        private String toHexString2(int value)
        {
            String s = Integer.toHexString(value).toUpperCase();
            if(s.length() == 1) s = "0" + s;
            return s;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser)
        {
            int r = seekBarR.getProgress();
            int g = seekBarG.getProgress();
            int b = seekBarB.getProgress();

            String sr = toHexString2(r);
            String sg = toHexString2(g);
            String sb = toHexString2(b);

            etykieta_panel.setBackgroundColor(Color.rgb(r,g,b));
            etykieta_panel.setText("Składowe koloru: #" + sr + sg + sb);

            //int jasność = (r + g + b) / 3; //intensity
            int jasność = (int)(0.299 * r + 0.587 * g + 0.144 * b); //luma
            //if (jasność > 127) etykieta_panel.setTextColor(Color.BLACK);
            //else etykieta_panel.setTextColor(Color.WHITE);
            etykieta_panel.setTextColor((jasność > 127) ? Color.BLACK : Color.WHITE);
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar)
        {
        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar)
        {
        }
    };
}
