package pl.umk.fizyka.kolory;

import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity {
    private SeekBar seekBarR, seekBarG, seekBarB;
    private TextView etykieta_panel;
    private Spinner spinner;
    private boolean czyUstawićSpinnerNaSuwaki = true;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        etykieta_panel = (TextView) findViewById(R.id.etykieta_panel);
        seekBarR = (SeekBar) findViewById(R.id.seekBarR);
        seekBarG = (SeekBar) findViewById(R.id.seekBarG);
        seekBarB = (SeekBar) findViewById(R.id.seekBarB);
        spinner = findViewById(R.id.spinner);

        seekBarR.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarG.setOnSeekBarChangeListener(seekBarChangeListener);
        seekBarB.setOnSeekBarChangeListener(seekBarChangeListener);

        //seekBarR.setProgress(0);
        //seekBarG.setProgress(0);
        //seekBarB.setProgress(0);

        seekBarChangeListener.onProgressChanged(null, 0, true);

        float promień = 8;
        float[] promienie = {promień, promień, promień, promień, promień, promień, promień, promień};
        RoundRectShape rrs = new RoundRectShape(promienie, null, null);

        ShapeDrawable sdR = new ShapeDrawable(rrs);
        sdR.getPaint().setShader(
                new LinearGradient(
                        0, 0, 400, 0, Color.BLACK, Color.RED, Shader.TileMode.CLAMP));
        seekBarR.setProgressDrawable(sdR);

        ShapeDrawable sdG = new ShapeDrawable(rrs);
        sdG.getPaint().setShader(
                new LinearGradient(
                        0, 0, 400, 0, Color.BLACK, Color.GREEN, Shader.TileMode.CLAMP));
        seekBarG.setProgressDrawable(sdG);

        ShapeDrawable sdB = new ShapeDrawable(rrs);
        sdB.getPaint().setShader(
                new LinearGradient(
                        0, 0, 400, 0, Color.BLACK, Color.BLUE, Shader.TileMode.CLAMP));
        seekBarB.setProgressDrawable(sdB);

        ArrayAdapter<?> adapter = ArrayAdapter.createFromResource(this, R.array.kolory, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinner.setAdapter(adapter);
        spinner.setOnItemSelectedListener(itemSelectedListener);

        if(!odtworzStan())
            spinner.setSelection(9);
    }

    private AdapterView.OnItemSelectedListener itemSelectedListener = new AdapterView.OnItemSelectedListener() {
        @Override
        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            czyUstawićSpinnerNaSuwaki = false;

            switch (position) {
                case 0:
                    break;
                case 1: //czarny
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(0);
                    break;
                case 2: //biały
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(255);
                    break;
                case 3: //czerwony
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(0);
                    break;
                case 4: //zielony
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(0);
                    break;
                case 5: //niebieski
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(255);
                    break;
                case 6: //turkusowy
                    seekBarR.setProgress(0);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(255);
                    break;
                case 7:
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(0);
                    seekBarB.setProgress(255);
                    break;
                case 8:
                    seekBarR.setProgress(255);
                    seekBarG.setProgress(255);
                    seekBarB.setProgress(0);
                    break;
                case 9:
                    seekBarR.setProgress(127);
                    seekBarG.setProgress(127);
                    seekBarB.setProgress(127);
                    break;
            }

            czyUstawićSpinnerNaSuwaki = true;
            //Konkurs: zrobić to bardziej elegancko tj. w switch wybór koloru, a następnie ustalanie pozycji suwaków zgodnie z wartościami składowych RGB
        }

        @Override
        public void onNothingSelected(AdapterView<?> parent) {
            //nic nie rób
        }
    };

    private SeekBar.OnSeekBarChangeListener seekBarChangeListener = new SeekBar.OnSeekBarChangeListener() {
        private String toHexString2(int value) {
            String s = Integer.toHexString(value).toUpperCase();
            if (s.length() == 1) s = "0" + s;
            return s;
        }

        @Override
        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            int r = seekBarR.getProgress();
            int g = seekBarG.getProgress();
            int b = seekBarB.getProgress();

            String sr = toHexString2(r);
            String sg = toHexString2(g);
            String sb = toHexString2(b);

            etykieta_panel.setBackgroundColor(Color.rgb(r, g, b));
            etykieta_panel.setText("Składowe koloru: #" + sr + sg + sb);

            //int jasność = (r + g + b) / 3; //intensity
            int jasność = (int) (0.299 * r + 0.587 * g + 0.144 * b); //luma
            //if (jasność > 127) etykieta_panel.setTextColor(Color.BLACK);
            //else etykieta_panel.setTextColor(Color.WHITE);
            etykieta_panel.setTextColor((jasność > 127) ? Color.BLACK : Color.WHITE);

            if (czyUstawićSpinnerNaSuwaki) spinner.setSelection(0);
        }

        @Override
        public void onStartTrackingTouch(SeekBar seekBar) {
        }

        @Override
        public void onStopTrackingTouch(SeekBar seekBar) {
        }
    };

    final String skladowaR = "SkladowaR";
    final String skladowaG = "SkladowaG";
    final String skladowaB = "SkladowaB";

    private void zapiszStan() {
        SharedPreferences.Editor edytorUstawień =
                getPreferences(MODE_PRIVATE).edit();
        edytorUstawień.putInt(skladowaR, seekBarR.getProgress());
        edytorUstawień.putInt(skladowaG, seekBarG.getProgress());
        edytorUstawień.putInt(skladowaB, seekBarB.getProgress());
        edytorUstawień.apply();
    }

    private boolean odtworzStan() {
        SharedPreferences ustawienia = getPreferences(MODE_PRIVATE);
        seekBarR.setProgress(ustawienia.getInt(skladowaR, 0));
        seekBarG.setProgress(ustawienia.getInt(skladowaG, 0));
        seekBarB.setProgress(ustawienia.getInt(skladowaB, 0));
        return ustawienia.contains(skladowaR) && ustawienia.contains(skladowaG) && ustawienia.contains(skladowaB);
    }

    @Override
    protected void onPause()
    {
        super.onPause();
        zapiszStan();
    }
}
