package pl.umk.fizyka.ulamekdemo;

import org.junit.Test;

import java.lang.reflect.Field;

import static org.junit.Assert.*;

/**
 * Example local unit test, which will execute on the development machine (host).
 *
 * @see <a href="http://d.android.com/tools/testing">Testing documentation</a>
 */
public class ExampleUnitTest
{
    @Test
    public void testKonstruktoraIWłasności()
            throws MianownikUłamkaRównyZero
    {
        //przygotowania (arrange)
        int licznik = 1;
        int mianownik = 2;

        //działanie (act)
        Ułamek u = new Ułamek(licznik, mianownik);
        int actualLicznik = u.getLicznik();
        int actualMianownik = u.getMianownik();

        //weryfikacja (assert)
        assertEquals("Niezgodność w liczniku", licznik, actualLicznik);
        assertEquals("Niezgodność w mianownik", mianownik, actualMianownik);
    }

    @Test
    public void testKonstruktora()
            throws MianownikUłamkaRównyZero, NoSuchFieldException, IllegalAccessException
    {
        //przygotowania (arrange)
        int licznik = 1;
        int mianownik = 2;

        //działanie (act)
        Ułamek u = new Ułamek(licznik, mianownik);

        //weryfikacja (assert)
        Field poleLicznik = Ułamek.class.getDeclaredField("licznik");
        Field poleMianownik = Ułamek.class.getDeclaredField("mianownik");
        poleLicznik.setAccessible(true);
        poleMianownik.setAccessible(true);
        int actualLicznik = poleLicznik.getInt(u);
        int actualMianownik = poleMianownik.getInt(u);

        assertEquals("Niezgodność w liczniku", licznik, actualLicznik);
        assertEquals("Niezgodność w mianownik", mianownik, actualMianownik);
    }
}