package pl.umk.fizyka.grafika2d;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class Grafika2DView extends View
{
    Paint paint;
    int szerokość, wysokość;

    public Grafika2DView(Context context, AttributeSet attributeSet)
    {
        super(context, attributeSet);

        paint = new Paint(Paint.ANTI_ALIAS_FLAG);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.ctor", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.ctor", "Wysokość: " + Integer.toString(wysokość));

        setBackgroundColor(Color.CYAN);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("onSizeChanged", "Szerokość: " + Integer.toString(szerokość));
        Log.d("onSizeChanged", "Wysokość: " + Integer.toString(wysokość));

        prost1 = new Rect(0, wysokość/2, szerokość, wysokość);
        prost2 = new Rect(szerokość/10,wysokość/3,5*szerokość/10,2*wysokość/3);
        prost3 = new Rect(7*szerokość/40,9*wysokość/20,5*szerokość/20,2*wysokość/3);
    }

    Rect prost1,prost2,prost3;

    @Override
    protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);

        //slońce
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(6);
        paint.setColor(Color.YELLOW);
        int x0 = 4*szerokość/5;
        int y0 = wysokość/4;
        int r1 = wysokość/10;
        canvas.drawCircle(x0,y0,r1,paint);

        //promienie
        int r2 = 2*r1;
        int ilePromieni = 16;
        double wsp = 2*Math.PI/ilePromieni;
        for(int i = 0; i < ilePromieni; ++i)
        {
            canvas.drawLine(
                    x0,y0,
                    x0+r2*(float)Math.cos(wsp*i),
                    y0+r2*(float)Math.sin(wsp*i),
                    paint);
        }

        //ziemia
        paint.setColor(Color.argb(255,191,255,0));
        canvas.drawRect(prost1, paint);

        //sciany domku
        paint.setColor(Color.WHITE);
        canvas.drawRect(prost2, paint);

        //drzwi
        paint.setColor(Color.argb(255,0,125,0));
        canvas.drawRect(prost3, paint);
    }
}
