package pl.umk.fizyka.powiadomienia;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.app.NotificationCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.*;

public class MainActivity extends AppCompatActivity
{
    private EditText tbTytul,tbTresc;
    private Button btnPokaz,btnUkryj;
    private int idPowiadomienia = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

       FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Snackbar.make(view, "Replace with your own action", Snackbar.LENGTH_LONG)
                        .setAction("Action", null).show();
            }
        });

        tbTytul=(EditText)findViewById(R.id.tbTytul);
        tbTresc=(EditText)findViewById(R.id.tbTresc);
        btnPokaz=(Button)findViewById(R.id.btnPokaz);
        btnUkryj=(Button)findViewById(R.id.btnUkryj);

        btnPokaz.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        Intent i = new Intent(getApplicationContext(), MainActivity.class);
                        PendingIntent pi = PendingIntent.getActivity(getApplicationContext(), 0, i, 0);

                        NotificationManager nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);

                        //region API >=26
                        String channelId = "kanał";
                        nm.createNotificationChannel(new NotificationChannel(channelId,"KanałUMK", NotificationManager.IMPORTANCE_DEFAULT));
                        //endregion

                        NotificationCompat.Builder nb = new NotificationCompat.Builder(getApplicationContext(), channelId);
                        nb.setSmallIcon(R.mipmap.ic_launcher);
                        nb.setContentTitle(tbTytul.getText());
                        nb.setContentText(tbTresc.getText());
                        nb.setContentIntent(pi);
                        nb.addAction(R.mipmap.ic_launcher_round,"Uruchom akcję", pi);
                        nb.addAction(R.mipmap.ic_launcher_round,"Uruchom akcję 2", pi);

                        Notification n = nb.build();
                        n.flags |= Notification.FLAG_AUTO_CANCEL;

                        nm.notify(idPowiadomienia, n);
                    }
                }
        );

        btnUkryj.setOnClickListener(
                new View.OnClickListener()
                {
                    @Override
                    public void onClick(View view)
                    {
                        NotificationManager nm = (NotificationManager)getSystemService(NOTIFICATION_SERVICE);
                        nm.cancel(idPowiadomienia);
                    }
                }
        );
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
