package pl.umk.fizyka.grafika2d;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

import java.util.ArrayList;
import java.util.List;

public class Grafika2DView extends View
{
    Paint paint;
    int szerokość, wysokość;

    public Grafika2DView(Context context, AttributeSet attributeSet)
    {
        super(context, attributeSet);

        paint = new Paint(Paint.ANTI_ALIAS_FLAG);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("View.ctor", "Szerokość: " + Integer.toString(szerokość));
        Log.d("View.ctor", "Wysokość: " + Integer.toString(wysokość));

        setBackgroundColor(Color.CYAN);
    }

    private Bitmap getBitmap(Drawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap(vectorDrawable.getIntrinsicWidth(),
                vectorDrawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh)
    {
        super.onSizeChanged(w, h, oldw, oldh);

        szerokość = getWidth();
        wysokość = getHeight();
        Log.d("onSizeChanged", "Szerokość: " + Integer.toString(szerokość));
        Log.d("onSizeChanged", "Wysokość: " + Integer.toString(wysokość));

        prost1 = new Rect(0, wysokość/2, szerokość, wysokość);
        prost2 = new Rect(szerokość/10,wysokość/3,5*szerokość/10,2*wysokość/3);
        prost3 = new Rect(7*szerokość/40,9*wysokość/20,5*szerokość/20,2*wysokość/3);
        prost4 = new Rect();
        rect4 = new Rect();

        ścieżka = new Path();
        ścieżka.setFillType(Path.FillType.EVEN_ODD);
        ścieżka.moveTo(szerokość / 10, wysokość / 3);
        ścieżka.lineTo(2 * szerokość / 10, wysokość / 6);
        ścieżka.lineTo(4 * szerokość / 10, wysokość / 6);
        ścieżka.lineTo(5 * szerokość / 10, wysokość / 3);
        ścieżka.lineTo(szerokość / 10, wysokość / 3);
        ścieżka.close();

        //TODO: nie zadziała na Androidzie z API 28!!!
        obraz = BitmapFactory.decodeResource(getResources(), R.mipmap.ic_launcher);
        if(obraz == null) Log.e("View.ctor", "Obraz nie został poprawnie wczytany");

        ścieżkiSztachet = new ArrayList<Path>();
        szer_plota = 6 * szerokość /10;
        wyso_ploat = wysokość / 5;
        x0_plota = szerokość/10;
        y0_plota = 9*wysokość/10;
        int liczba_sztachet = 20;
        int szerokość_sztachety = szer_plota / ((liczba_sztachet *2));
        int curr_x = x0_plota+ szerokość_sztachety;
        while (curr_x <= (szer_plota+x0_plota-szerokość_sztachety))
        {
            Path path1 = new Path();
            path1.moveTo(curr_x, y0_plota);
            path1.lineTo(curr_x, y0_plota - 4*wyso_ploat/5);
            path1.lineTo(curr_x + szerokość_sztachety/2, y0_plota - wyso_ploat);
            path1.lineTo(curr_x+szerokość_sztachety, y0_plota - 4*wyso_ploat/5);
            path1.lineTo(curr_x+szerokość_sztachety, y0_plota);
            path1.lineTo(curr_x, y0_plota);
            path1.close();
            ścieżkiSztachet.add(path1);
            curr_x+= 2*szerokość_sztachety;
        }
    }

    Rect prost1,prost2,prost3;
    Rect prost4, rect4;
    Path ścieżka;
    List<Path> ścieżkiSztachet;
    Bitmap obraz;
    static long aktualnyCzas = -1, poprzedniCzas = -1;
    final int liczba_sztachet = 20;
    int szer_plota, wyso_ploat, x0_plota, y0_plota;

    @Override
    protected void onDraw(Canvas canvas)
    {
        super.onDraw(canvas);

        //slońce
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeWidth(6);
        paint.setColor(Color.YELLOW);

        {
            int x0 = 4 * szerokość / 5;
            int y0 = wysokość / 4;
            int r1 = wysokość / 10;
            canvas.drawCircle(x0, y0, r1, paint);

            //promienie
            int r2 = 2 * r1;
            int ilePromieni = 16;
            double wsp = 2 * Math.PI / ilePromieni;
            for (int i = 0; i < ilePromieni; ++i) {
                canvas.drawLine(
                        x0, y0,
                        x0 + r2 * (float) Math.cos(wsp * i),
                        y0 + r2 * (float) Math.sin(wsp * i),
                        paint);
            }

            //ziemia
            paint.setColor(Color.argb(255, 191, 255, 0));
            canvas.drawRect(prost1, paint);

            //sciany domku
            paint.setColor(Color.WHITE);
            canvas.drawRect(prost2, paint);

            //drzwi
            paint.setColor(Color.argb(255, 0, 125, 0));
            canvas.drawRect(prost3, paint);
        }

        //okno
        paint.setColor(Color.CYAN);
        for(int ix = 0; ix < 2; ++ix)
            for(int iy = 0; iy < 2; ++iy)
            {
                int x0 = 13 * szerokość / 40;
                int y0 = 2 * wysokość / 5;
                int x1 = x0 + ix * szerokość / 15;
                int y1 = y0 + iy * wysokość / 15;
                int x2 = x1 + szerokość / 20;
                int y2 = y1 + wysokość / 20;
                prost4.left = x1;
                prost4.top = y1;
                prost4.right = x2;
                prost4.bottom = y2;
                canvas.drawRect(prost4, paint);
            }

        //dach
        paint.setColor(Color.RED);
        canvas.drawPath(ścieżka, paint);

        if(aktualnyCzas < 0)
        {
            aktualnyCzas = System.currentTimeMillis();
            poprzedniCzas = aktualnyCzas;
        }
        else
        {
            poprzedniCzas = aktualnyCzas;
            aktualnyCzas = System.currentTimeMillis();
        }

        final double f = 0.001;

        //obrazek - animacja
        if(obraz != null)
        {
            int x0 = szerokość / 2;
            int y0 = 4 * wysokość / 10;
            float wsp = (float) obraz.getHeight() / obraz.getWidth();
            int dx = szerokość / 5;
            int dy = (int) (y0 * wsp);
            int xoffset = (int)(szerokość / 4 * Math.sin(f*aktualnyCzas));
            canvas.drawBitmap(obraz, null, new Rect(x0 + xoffset, y0, x0 + dx + xoffset, y0 + dy), paint);
        }

        //plot
        paint.setColor(getResources().getColor(R.color.brazowy));
        rect4.left = x0_plota;
        rect4.right = rect4.left + szer_plota;
        rect4.bottom = y0_plota - wyso_ploat/4;
        rect4.top = rect4.bottom - wysokość/40;
        canvas.drawRect(rect4, paint);
        rect4.bottom = rect4.bottom - wyso_ploat/4;
        rect4.top = rect4.top - wyso_ploat/4;
        canvas.drawRect(rect4, paint);
        //sztachety
        for(Path path1 : ścieżkiSztachet)
            canvas.drawPath(path1, paint);

        //napis
        paint.setColor(Color.BLACK);
        paint.setStrokeWidth(0.3f);
        paint.setTextSize(30f);

        double interwał = aktualnyCzas - poprzedniCzas;
        interwał /= 1000;

        String tekst = "FPS: " + Double.toString(Math.round(100/interwał)/100);
        float margines = wysokość / 30;
        float w = paint.measureText(tekst);
        canvas.drawText(tekst, szerokość - margines - w, wysokość - margines, paint);

        invalidate();
    }
}
