package pl.umk.fizyka.bazadanych_sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import java.util.ArrayList;

public class BazaDanychOsób extends SQLiteOpenHelper
{
    public BazaDanychOsób(Context context)
    {
        super(context, "osoby.db", null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase)
    {
        String createCommand = "create table " + Osoba.nazwaTabeli + "(";
        for(int numerKolumny = 0; numerKolumny < Osoba.nazwyKolumnTabeli.length; ++numerKolumny)
        {
            String nazwaKolumny = Osoba.nazwyKolumnTabeli[numerKolumny];
            String własnośćKolumny = Osoba.własnościKolumnTabeli[numerKolumny];
            createCommand += nazwaKolumny + " " + własnośćKolumny;
            if(numerKolumny < Osoba.nazwyKolumnTabeli.length - 1) createCommand += ",";
        }
        createCommand += ")";
        sqLiteDatabase.execSQL(createCommand);
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion)
    {
        //zmiana wersji
    }

    private ContentValues wartościZOsoby(Osoba osoba)
    {
        ContentValues wartości = new ContentValues();
        wartości.put(Osoba.nazwyKolumnTabeli[0], osoba.ID);
        wartości.put(Osoba.nazwyKolumnTabeli[1], osoba.Imię);
        wartości.put(Osoba.nazwyKolumnTabeli[2], osoba.Nazwisko);
        wartości.put(Osoba.nazwyKolumnTabeli[3], osoba.Wiek);
        wartości.put(Osoba.nazwyKolumnTabeli[4], osoba.NumerTelefonu);
        return wartości;
    }

    public void dodajRekord(Osoba osoba)
    {
        SQLiteDatabase db = getWritableDatabase();
        ContentValues wartości = wartościZOsoby(osoba);
        db.insertOrThrow(Osoba.nazwaTabeli, null, wartości);
    }

    private Osoba bieżącaOsoba(Cursor karetka)
    {
        Osoba osoba = new Osoba(
                karetka.getInt(0),
                karetka.getString(1),
                karetka.getString(2),
                karetka.getInt(3),
                karetka.getInt(4)
        );
        return osoba;
    }

    public Osoba[] pobierzWszystkieRekordy(String orderBy)
    {
        SQLiteDatabase db = getReadableDatabase();
        Cursor karetka = db.query(Osoba.nazwaTabeli, Osoba.nazwyKolumnTabeli, null, null, null, null, orderBy);
        ArrayList<Osoba> lista = new ArrayList<Osoba>();
        while(karetka.moveToNext())
        {
            lista.add(bieżącaOsoba(karetka));
        }
        karetka.close();
        Osoba[] tablica = new Osoba[lista.size()];
        lista.toArray(tablica);
        return tablica;
    }

    public boolean usuńRekord(int id)
    {
        SQLiteDatabase db = getWritableDatabase();
        String[] whereArgs = { Integer.toString(id) };
        return db.delete(Osoba.nazwaTabeli, "ID=?", whereArgs) > 0;
    }

    public boolean zmieńRekord(int id, Osoba osoba)
    {
        SQLiteDatabase db = getWritableDatabase();
        ContentValues wartości = wartościZOsoby(osoba);
        String[] whereArgs = { Integer.toString(id) };
        return db.update(Osoba.nazwaTabeli, wartości, "ID=?", whereArgs) > 0;
    }

    public Osoba pobierzRekord(int id)
    {
        try
        {
            SQLiteDatabase db = getWritableDatabase();
            String[] whereArgs = {Integer.toString(id)};
            Cursor karetka = db.query(Osoba.nazwaTabeli, Osoba.nazwyKolumnTabeli, "ID=?", whereArgs, null, null, null);
            karetka.moveToFirst();
            {
                Osoba osoba = bieżącaOsoba(karetka);
                karetka.close();
                return osoba;
            }
        }
        catch(Exception exc)
        {
            throw exc;
        }
    }
}
