package pl.umk.fizyka.bazadanych_sqlite;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
{
    TextView tv;

    private void pokażRekordy(Osoba[] osoby)
    {
        //tv.setText(Integer.toString(osoby.length));
        String s = "Rekordy:";
        for(Osoba o : osoby) s += "\n" + o.toString();
        //tv.setText(s);
        String text = tv.getText().toString();
        tv.setText(text + "\n\n" + s);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        tv = findViewById(R.id.textView);

        boolean wynik = this.deleteDatabase("osoby.db");

        BazaDanychOsób dbm = new BazaDanychOsób(this);
        dbm.dodajRekord(new Osoba(0, "Jacek", "Matulewski", 46, 34567890));
        dbm.dodajRekord(new Osoba(1, "Mateusz", "Chojnowski", 22, 987654321));
        dbm.dodajRekord(new Osoba(2, "Piotr", "Jabłoński", 24, 642536437));
        dbm.dodajRekord(new Osoba(3, "Jakub", "Lesiak", 25, 74365837));
        dbm.dodajRekord(new Osoba(4, "Krystian", "Jabłoński", 23, 284353897));

        Osoba[] osoby = dbm.pobierzWszystkieRekordy("Wiek");
        pokażRekordy(osoby);

        dbm.usuńRekord(1);

        osoby = dbm.pobierzWszystkieRekordy("Wiek");
        pokażRekordy(osoby);

        //dbm.zmieńRekord(0, new Osoba(0, "Jacek", "Zakrzewski", 30, 387658743));

        //osoby = dbm.pobierzWszystkieRekordy("Wiek");
        //pokażRekordy(osoby);

        Osoba o = dbm.pobierzRekord(0);
        tv.setText(o.toString());

        //dbm.close();
    }
}
