﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile;
using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.PocketOutlook.MessageInterception;
using Microsoft.WindowsMobile.Telephony;

namespace PrzechwytywanieSMS
{
    public partial class Form1 : Form
    {
        MessageInterceptor przechwytywanieSms;
        string id = "unikalny identyfikator";

        public Form1()
        {
            InitializeComponent();
            ustawPrzechwytywanieSms(out przechwytywanieSms);
        }

        ~Form1()
        {
            MessageBox.Show("Destruktor");
        }

        /*
        void ustawPrzechwytywanieSms(out MessageInterceptor przechwytywanieSms)
        {
            przechwytywanieSms = new MessageInterceptor(InterceptionAction.NotifyAndDelete);
            przechwytywanieSms.MessageCondition = new MessageCondition(MessageProperty.Body, MessagePropertyComparisonType.StartsWith,"cmd:",true);
            przechwytywanieSms.MessageReceived += new MessageInterceptorEventHandler(przechwytywanieSms_MessageReceived);
            listBox1.Items.Add("Przechwytywanie SMSów włączone");
        }
        */

        void ustawPrzechwytywanieSms(out MessageInterceptor przechwytywanieSms)
        {
            if (!MessageInterceptor.IsApplicationLauncherEnabled(id))
            {
                przechwytywanieSms = new MessageInterceptor(InterceptionAction.NotifyAndDelete);
                przechwytywanieSms.MessageCondition = new MessageCondition(MessageProperty.Body, MessagePropertyComparisonType.StartsWith, "cmd:", true);
                przechwytywanieSms.EnableApplicationLauncher(id);
                listBox1.Items.Add("Tworze pierwszy obiekt");
            }
            else
            {
                przechwytywanieSms = new MessageInterceptor(id);
                listBox1.Items.Add("Przywołuję obiekt");
            }
            przechwytywanieSms.MessageReceived += new MessageInterceptorEventHandler(przechwytywanieSms_MessageReceived);
            listBox1.Items.Add("Przechwytywanie SMSów włączone");
        }

        void przechwytywanieSms_MessageReceived(object sender, MessageInterceptorEventArgs e)
        {
            string plikExe = System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase;
            System.Diagnostics.Process.Start(plikExe, "");

            SmsMessage sms = e.Message as SmsMessage;
            listBox1.Items.Add(sms.From.Name + " " + sms.Body);
            if (sms.Body.StartsWith("cmd:callback"))
            {
                string nt = sms.From.Address;
                if (nt.Contains(">"))
                {
                    nt = nt.Remove(0, nt.LastIndexOf("<" + 1));
                    nt = nt.Remove(nt.LastIndexOf(">"), nt.Length - nt.LastIndexOf(">"));
                }
                listBox1.Items.Add("   Oddwaniam na numer: " + nt);

                new Phone().Talk(nt);
            }
            else listBox1.Items.Add("Polecenie nierozpoznane: " + sms.Body);            
        }

        private void Form1_Closed(object sender, EventArgs e)
        {
            DialogResult wybor = MessageBox.Show(
                "Czy chcesz reagować na polecenia w wiadomościach SMS za pomocą tej aplikacji po jej zamknięciu?",
                "Zachować przechwytywanie?",
                MessageBoxButtons.YesNo,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button2);
            if (wybor == DialogResult.No) przechwytywanieSms.DisableApplicationLauncher();

            przechwytywanieSms.MessageReceived -= przechwytywanieSms_MessageReceived;
            przechwytywanieSms.Dispose();
        }
    }
}