﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace KoloryWindowsPhone.ModelWidoku
{
    using Model;
    using System.ComponentModel;
    using System.Windows.Media;

    public class ModelWidoku1 : INotifyPropertyChanged
    {
        private byte r, g, b;

        public byte R 
        {
            get
            {
                return r;
            }
            set
            {
                r = value;
                OnPropertyChanged("R");
                OnPropertyChanged("Color");
            }
        }
        public byte G
        {
            get
            {
                return g;
            }
            set
            {
                g = value;
                OnPropertyChanged("G");
                OnPropertyChanged("Color");
            }
        }
        public byte B
        {
            get
            {
                return b;
            }
            set
            {
                b = value;
                OnPropertyChanged("B");
                OnPropertyChanged("Color");
            }
        }

        public Color Color
        {
            get
            {
                return Color.FromArgb(255, R, G, B);
            }
        }

        public ModelWidoku1()
        {
            //czytanie?
            Model model = new Model(255,255,255);
            R = model.R;
            G = model.G;
            B = model.B;
        }

        void Zapisz()
        {
            Model model = new Model(R, G, B);
            //zapisywanie(model);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }

    public class ModelWidoku2 : INotifyPropertyChanged
    {
        private Model model;
        
        public byte R 
        { 
            get
            {
                return model.R;
            }
            set
            {
                model.R = value;
                OnPropertyChanged("R");
                OnPropertyChanged("Color");
            }
        }
        public byte G 
        { 
            get
            {
                return model.G;
            }
            set
            {
                model.G = value;
                OnPropertyChanged("G");
                OnPropertyChanged("Color");
            }
        }
        public byte B
        { 
            get
            {
                return model.B;
            }
            set
            {
                model.B = value;
                OnPropertyChanged("B");
                OnPropertyChanged("Color");
            }
        }

        public Color Color
        {
            get
            {
                return Color.FromArgb(255, R, G, B);
            }
        }

        public ModelWidoku2()
        {
            model = new Model(255,255,255);
        }

        void Zapisz()
        {            
            //zapisywanie(model);
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(string nazwaWłasności)
        {
            if (PropertyChanged != null) PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
        }
    }

    public class ModelWidoku3 //nie ma możliwości zaimplementowania INotifyPropertyChanged (inaczej niż w modelu)
    {
        public Model Model;

        public ModelWidoku3()
        {
            Model = new Model(255, 255, 255);
        }
    }
}
