﻿using MvvmCross.Platform.Converters;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Kolory.Core.Converters
{
    public class ByteToDoubleConverter : IMvxValueConverter
    {
        public object Convert(object value, Type targetType, object parameter,
                              System.Globalization.CultureInfo culture)
        {
            return (double)(byte)value;
        }

        public object ConvertBack(object value, Type targetType, object parameter,
                                  System.Globalization.CultureInfo culture)
        {
            if(value.GetType() == typeof(int))
            {
                return (byte)(double)(int)value;
            }
            else
            {
                return (byte)(double)value;
            }
        }
    }

}
