using MvvmCross.Binding.BindingContext;
using MvvmCross.iOS.Views;
using MvvmCross.iOS.Views.Presenters.Attributes;

namespace Kolory.iOS.Views
{
    [MvxRootPresentation(WrapInNavigationController = true)]
    public partial class MainView : MvxViewController
    {
        public MainView() : base("MainView", null)
        {

        }

        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            var set = this.CreateBindingSet<MainView, Core.ViewModels.MainViewModel>();
            set.Bind(sliderR).To(vm => vm.R);
            set.Bind(sliderG).To(vm => vm.G);
            set.Bind(sliderB).To(vm => vm.B);
            set.Bind(color)
                .For(field => field.BackgroundColor)
                .To(vm => vm.CurrentColor)
                .WithConversion("NativeColor");
            set.Bind(Button).To(vm => vm.ResetColorCommand);
            set.Apply();
        }
    }
}
