﻿using Android.App;
using Android.Widget;
using Android.OS;
using Android.Support.V7.App;
using Android.Graphics; //<------

namespace Kolory
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        //pola
        private TextView etykieta_panel; //Label, pełni też rolę panela
        private SeekBar seekBarR, seekBarG, seekBarB; //TrackBar

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            etykieta_panel = (TextView)FindViewById(Resource.Id.etykieta_panel);
            seekBarR = (SeekBar)FindViewById(Resource.Id.seekBarR);
            seekBarG = (SeekBar)FindViewById(Resource.Id.seekBarG);
            seekBarB = (SeekBar)FindViewById(Resource.Id.seekBarB);

            seekBarR.ProgressChanged += SeekBar_ProgressChanged;
            seekBarG.ProgressChanged += SeekBar_ProgressChanged;
            seekBarB.ProgressChanged += SeekBar_ProgressChanged;
        }

        private void SeekBar_ProgressChanged(object sender, SeekBar.ProgressChangedEventArgs e)
        {
            int r = seekBarR.Progress;
            int g = seekBarG.Progress;
            int b = seekBarB.Progress;

            etykieta_panel.SetBackgroundColor(Color.Argb(255, r, g, b));
            etykieta_panel.SetText(
                    "Składowe koloru: " +
                    r.ToString("X2").ToUpper() + " " +
                    g.ToString("X2").ToUpper() + " " +
                    b.ToString("X2").ToUpper() + " ", TextView.BufferType.Normal);

            int jasnosc = (r + g + b) / 3;
            if (jasnosc > 127) etykieta_panel.SetTextColor(Color.Black);
            else etykieta_panel.SetTextColor(Color.White);
        }
    }
}

