﻿using Android;
using Android.App;
using Android.Content;
using Android.Content.PM;
using Android.OS;
using Android.Support.V4.App;
using Android.Support.V4.Content;
using Android.Support.V7.App;
using Android.Telephony;
using Android.Widget;

namespace Intencje
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            Button przycisk = FindViewById<Button>(Resource.Id.przycisk);
            przycisk.Click += Przycisk_Click;
        }

        static private bool zdobądźUprawnienia(Activity activity, string permission, int requestCode)
        {
            //int permissionCheck = ContextCompat.checkSelfPermission(activity, android.Manifest.permission.READ_PHONE_STATE);
            Permission permissionCheck = ContextCompat.CheckSelfPermission(activity, permission);
            if (permissionCheck != Permission.Granted)
            {
                ActivityCompat.RequestPermissions(
                        activity,
                        new string[] { permission },
                        //requestReadPhoneState);
                        requestCode);
                return false;
            }
            else return true;
        }

        private void Przycisk_Click(object sender, System.EventArgs e)
        {
            /*
            Intent i = new Intent(this, typeof(InnaAktywnosc));
            //Finish();
            StartActivity(i);
            */

            /*
            Intent i = new Intent(Intent.ActionView);
            i.SetData(Android.Net.Uri.Parse("http://www.fizyka.umk.pl/~jacek/"));
            StartActivity(i);
            */

            /*
            Intent i = new Intent(Intent.ActionWebSearch);
            i.PutExtra(SearchManager.Query, "UMK");
            StartActivity(i);
            */

            /*
            double latitude = 53.017100;
            double longitude = 18.602889;
            double zoom = 1.85; //wartości od 1 do 23
            string uri = "geo:" + latitude.ToString() + "," + longitude.ToString() + "?z=" + zoom.ToString();
            Intent i = new Intent(Intent.ActionView, Android.Net.Uri.Parse(uri));
            StartActivity(i);
            */

            /*
            string uri = "geo:0,0?q=Torun Gagarina 11";
            Intent i = new Intent(Intent.ActionView, Android.Net.Uri.Parse(uri));
            StartActivity(i);
            */

            /*
            string numerTelefonu = "+48 123 456 789";
            Intent i = new Intent(Intent.ActionCall);
            i.SetData(Android.Net.Uri.Parse("tel:" + numerTelefonu));
            StartActivity(i);
            */

            /*
            string numerTelefonu = "+48 123 456 789";
            Intent i = new Intent(Intent.ActionCall);
            i.SetData(Android.Net.Uri.Parse("tel:" + numerTelefonu));
            if (ContextCompat.CheckSelfPermission(this, Android.Manifest.Permission.CallPhone) != Android.Content.PM.Permission.Granted)
            {
                ActivityCompat.RequestPermissions(this, new string[] { Android.Manifest.Permission.CallPhone }, 0); //, MY_PERMISSIONS_REQUEST_CALL_PHONE);
            }
            else
            {                
                try
                {
                    StartActivity(i);
                }
                catch (Java.Lang.SecurityException _e)
                {
                    _e.PrintStackTrace();
                }
            }
            */

            /*
            try
            {
                string numerTelefonu = "+48 123 456 789";
                if (zdobądźUprawnienia(this, Manifest.Permission.CallPhone, 0))
                {
                    Intent i = new Intent(Intent.ActionCall);
                    i.SetData(Android.Net.Uri.Parse("tel:" + numerTelefonu));
                    StartActivity(i);
                }
                else Toast.MakeText(ApplicationContext, "Brak uprawnień", ToastLength.Long).Show();
            }
            catch (Java.Lang.SecurityException exc)
            {
                Toast.MakeText(ApplicationContext, exc.Message, ToastLength.Long).Show();
            }
            */

            /*
            //Dzwonienie bez pobierania uprawnień (pokazane zostanie okno, w którym użytkownik widzi numer i decyduje o rozpoczęciu połączenia)
            try
            {
                string numerTelefonu = "+48 123 456 789";
                Intent i = new Intent(Intent.ActionDial);
                i.SetData(Android.Net.Uri.Parse("tel:" + numerTelefonu));
                if (ActivityCompat.CheckSelfPermission(this, Manifest.Permission.CallPhone) != Permission.Granted)
                {
                    throw new System.Exception("Nie uzyskano zgody");
                }
                else StartActivity(i);
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext, exc.Message, ToastLength.Long).Show();
            }
            */

            /*
            string numerTelefonu = "+48 123 456 789";
            Intent i = new Intent(Intent.ActionDial);
            i.SetData(Android.Net.Uri.Parse("tel:" + numerTelefonu));
            StartActivity(i);
            */

            /*
            string tekst = "Przykładowa treść";
            string numerTelefonu = "+48 123 456 789";
            Intent i = new Intent(Intent.ActionSendto, Android.Net.Uri.Parse("smsto:" + numerTelefonu));
            i.PutExtra("sms_body", tekst);
            StartActivity(i);
            */

            /*
            string tekst = "Przykładowa treść";
            string numerTelefonu = "+48 123 456 789";
            SmsManager sms = SmsManager.Default;
            Intent i = new Intent(this, typeof(InnaAktywnosc));
            PendingIntent pi = PendingIntent.GetActivity(this, 0, i, 0);
            sms.SendTextMessage(numerTelefonu, null, tekst, null, null); //wymaga uprawnień
            */

            try
            {
                string numerTelefonu = "+48 123 456 789";
                zdobądźUprawnienia(this, Manifest.Permission.SendSms, 0);
                SmsManager sms = SmsManager.Default;
                PendingIntent pi = PendingIntent.GetActivity(
                        BaseContext, 0,
                        new Intent(BaseContext, typeof(MainActivity)),
                        0);
                sms.SendTextMessage(
                        numerTelefonu, null, "Przykładowy SMS",
                        null, null);
            }
            catch (Java.Lang.Exception exc)
            {
                Toast.MakeText(ApplicationContext, exc.Message, ToastLength.Long).Show();
            }
        }
    }
}