﻿using Android.App;
using Android.OS;
using Android.Support.V7.App;
using Android.Runtime;
using Android.Widget;
using Android.Views;

namespace Pierscien
{
    [Activity(Label = "@string/app_name", Theme = "@style/AppTheme", MainLauncher = true)]
    public class MainActivity : AppCompatActivity
    {
        private void pokażToast(string komunikat)
        {
            RunOnUiThread(() => { Toast.MakeText(this, komunikat, ToastLength.Short).Show(); });
        }

        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);
            // Set our view from the "main" layout resource
            SetContentView(Resource.Layout.activity_main);

            Java.Lang.Thread t = new Java.Lang.Thread(
                () =>
                {
                    try
                    {
                        Java.Lang.Thread.Sleep(5000); //zamiast tego powinno byc inicjowanie widoku
                        pokażToast("Działanie wątku zakończone");
                    }
                    catch (Java.Lang.InterruptedException exc)
                    {
                        pokażToast("Działanie wątku przerwane");
                    }
                    finally
                    {
                        RunOnUiThread(
                            () =>
                            {
                                View panelPierscienia = FindViewById<View>(Resource.Id.panelPierscienia);
                                panelPierscienia.Visibility = ViewStates.Gone;
                                Toast.MakeText(this, "Panel pierściania ukryty", ToastLength.Short).Show();
                            });
                    }
                }
            );
            t.Start();
        }
    }
}