﻿using System.Collections.Generic;

using Android.Content;
using Android.Database;
using Android.Provider;

namespace Kontakty
{
    class Kontakt
    {
        //pozniej bedziemy czytali liste rekordów z większą ilością szczegółów
        public static List<string> ListaNazwWszystkichKontaktow(ContentResolver contentResolver)
        {
            List<string> lista = new List<string>();
            ICursor cursor = contentResolver.Query(ContactsContract.Contacts.ContentUri, null, null, null, null);
            if (cursor.Count > 0)
            {
                while (cursor.MoveToNext())
                {
                    string nazwa = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.DisplayName));
                    string id = cursor.GetString(cursor.GetColumnIndex(ContactsContract.Contacts.InterfaceConsts.Id));
                    lista.Add("[" + id + "] " + nazwa);
                }
            }
            else
            {
                lista = null;
            }
            cursor.Close();
            return lista;
        }
    }
}